/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: basic_status.h,v 1.9 2013/09/13 12:53:20 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __BASIC_STATUS_H__
#define __BASIC_STATUS_H__

#include "gui.h"
#include "sql_service.h"
#include "sql_query.h"
#include "sql_privileges_flags.h"


class BasicStatusItem;
class QueriesItem;
//class SqlPrivileges;
typedef	QVector<BasicStatusItem *>	BasicStatusVector;

class BasicStatus:public QWidget, public SqlService
{
	Q_OBJECT
public:
	BasicStatus(ServerInfo *, QWidget *parent = NULL);
	virtual ~BasicStatus();

	virtual void	privilegesChanged();

	SqlConnection	*connection()const;

	virtual void	timeout();

	virtual QString	tabName();

private:
	QVBoxLayout		*layout;
	QScrollArea		*area;
	QWidget			*status;
	QFormLayout		*form;
	QLabel			*qsize;
	BasicStatusVector	vect;
	QueriesItem		*q;
	QLabel			*q_avg;
	BasicStatusItem		*uptime;
	QDialogButtonBox	*box;
	QPushButton		*sdb;
	QPushButton		*rb;

	void	addStatus(SqlQuery::Scope, SqlQuery::Table, const QString&,
			const QString&);
	void	destroyVector();
	void	computeAvgQ();

protected:
	virtual void	destroyIt();	/* we don't use it in this class */

signals:
	void	reject();
	void	shutdown();
	void	refresh();
};

//-----------------------------------------------------------------------------

class BasicStatusItem:public QLabel
{
	Q_OBJECT
public:
	BasicStatusItem(SqlQuery::Scope, SqlQuery::Table, const QString&,
		QWidget *parent = NULL);
	~BasicStatusItem();

	void	timeout();

private:
	SqlQuery	*query;

private slots:
	void	readData();
};

//-----------------------------------------------------------------------------

class QueriesItem:public BasicStatusItem
{
	Q_OBJECT
public:
	QueriesItem(QWidget *parent = NULL);
	~QueriesItem();

	quint64	queries()const;
};

#endif  /* __BASIC_STATUS_H__ */

/* EOF */
