/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: core.cpp,v 1.23 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "gui.h"
#include "mainwindow.h"
#include "settings.h"
#include "legend_item.h"
#include "sql_account_legend.h"
#include "sql_error.h"

#define	LOCALE_SYSPATH	QLibraryInfo::location(QLibraryInfo::TranslationsPath)


/* Main program entry */
int
main(int argc, char **argv)
{
	QApplication	*app;
	MainWindow	*mw;
	QTranslator	*qt, *app_tr;
	Settings	*settings;
	QTextCodec	*codec;
	int		ret;

	SqlError::registerMeta();
	Q_INIT_RESOURCE(core);

	QCoreApplication::setOrganizationName(DEFAULT_ORGANIZATION);
	QCoreApplication::setApplicationName(DEFAULT_APPLICATION);

	codec = QTextCodec::codecForName("UTF-8");
	if (codec != NULL) {
		QTextCodec::setCodecForCStrings(codec);
		QTextCodec::setCodecForTr(codec);
	}

	app = new QApplication(argc, argv);
	FATAL(app == NULL);

	qt = Core::installTranslator("qt");
	app_tr = Core::installTranslator(LOCALE_FILE);

	settings = new Settings();
	settings->setTranslation(app_tr != NULL);
	settings->load();
	mw = new MainWindow(settings);
	FATAL(mw == NULL);

	mw->setGeometry(settings->geometry());
	mw->setMinimumSize(DEFAULT_WINDOW_SIZE);
	mw->show();

	ret = app->exec();

	settings->setGeometry(mw->geometry());
	delete mw;

	settings->save();
	delete settings;

	DELETE_TRANSLATOR(app_tr);
	DELETE_TRANSLATOR(qt);
	delete app;

	Q_CLEANUP_RESOURCE(core);

	return (ret);
}

//-----------------------------------------------------------------------------

void
Core::noData(QWidget *parent)
{

	QMessageBox::information(parent, QObject::tr("No data"),
		QObject::tr("No data selected to complete this action"));
}


void
Core::notImplemented(QWidget *parent)
{

	QMessageBox::information(parent, QObject::tr("Not implemented"),
		QObject::tr("I'm so sorry, but this function is not yet "
		"implemented"));
}


bool
Core::doubleConfirm(const Confirm &q, const Confirm &w, QWidget *parent)
{
	static QString	q_title(QObject::tr("Confirmation")),
			w_title(QObject::tr("Last warning"));
	bool		ret = FALSE;
	const QString	*qt_ptr = &(q.title.isEmpty()?q_title:q.title);
	const QString	*wt_ptr = &(w.title.isEmpty()?w_title:w.title);

	if ((QMessageBox::question(parent, *qt_ptr, q.text,
		QMessageBox::Yes | QMessageBox::No, QMessageBox::No) ==
		QMessageBox::Yes) &&
		(QMessageBox::warning(parent, *wt_ptr, w.text,
		QMessageBox::Yes | QMessageBox::No, QMessageBox::No) ==
		QMessageBox::Yes))
		ret = TRUE;

	return (ret);
}


QString
Core::hasPassword(const QString &pass)
{

	return (hasValue(!pass.isEmpty()));
}


QString
Core::hasValue(bool has)
{

	return (text(has?Core::Yes:Core::No));
}


QString
Core::text(Text txt)
{
	static QMap<Text, QString>	messages;

	if (messages.empty()) {
		messages[Yes] = QObject::tr("Yes");
		messages[No] = QObject::tr("No");
		messages[Add] = QObject::tr("Add");
		messages[Edit] = QObject::tr("Edit");
		messages[Delete] = QObject::tr("Delete");
		messages[Close] = QObject::tr("Close");
		messages[Undefined] = QObject::tr("Undefined");
		messages[Unlimited] = QObject::tr("Unlimited");
		messages[NoDescription] = QObject::tr("No description");
		messages[NewObjectPrivileges] =
			QObject::tr("New object privileges");
		messages[Procedure] = QObject::tr("Procedure");
		messages[Function] = QObject::tr("Function");
		messages[Unknown] = QObject::tr("Unknown");
		messages[None] = QObject::tr("None");
		messages[Unused] = QObject::tr("Unused");
		messages[UnknownVariable] = QObject::tr("Unknown variable");
	}

	return (messages[txt]);
}


/* table with some status information and other stuff */
QString
Core::informationSchema(const QString &table)
{
	static QString	systbl("information_schema"), format("`%1`.`%2`");
	QString		ret;

	if (table.isEmpty())
		ret = systbl;
	else
		ret = format.arg(systbl).arg(table);

	return (ret);
}


QString
Core::systemTable(const QString &table)
{
	static QString	systbl("mysql"), format("`%1`.`%2`");
	QString		ret;

	if (table.isEmpty())
		ret = systbl;
	else
		ret = format.arg(systbl).arg(table);

	return (ret);
}


QString
Core::bool2string(bool ena)
{

	return (ena?"ON":"OFF");
}


bool
Core::string2bool(const QString &str)
{
	bool			ret;
	Qt::CaseSensitivity	sens = Qt::CaseInsensitive;

	if ((str.compare("ON", sens) == 0) ||
		(str.compare("TRUE", sens) == 0) ||
		(str.compare("1", sens) == 0))
		ret = TRUE;
	else
		ret = FALSE;

	return (ret);
}


QWidget *
Core::addLegendItem(const QString &text, const QBrush &brush, QWidget *parent)
{
	LegendItem	*ret;

	ret = new LegendItem(brush, text, parent);

	return (ret);
}


QWidget *
Core::accountLegend(QWidget *parent)
{
	QWidget	*ret;

	ret = new SqlAccountLegend(parent);
	FATAL(ret == NULL);

	return (ret);
}


QTranslator *
Core::installTranslator(const QString &tr, QObject *parent)
{
	QTranslator	*ret;
	QString		file, locale(QLocale::system().name()),
			locale_path(LOCALE_PATH),
			locale_syspath(LOCALE_SYSPATH);

	file = QString("%1_%2").arg(tr).arg(locale);
	ret = new QTranslator(parent);
	FATAL(ret == NULL);
	if (ret->load(file, locale_path) || ret->load(file, locale_syspath))
		QApplication::installTranslator(ret);
	else
		SAFE_DELETE(ret);

	return (ret);
}

//-----------------------------------------------------------------------------

ostream &
operator<<(ostream &o, const QString &str)
{

	o<<str.toUtf8().constData();

	return (o);
}

/* EOF */
