/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: legend_item.cpp,v 1.2 2013/08/01 14:01:08 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "legend_item.h"


LegendItem::LegendItem(QWidget *parent)
	:QWidget(parent)
{

	initItem();
}

LegendItem::LegendItem(const QBrush &br, const QString &txt, QWidget *parent)
	:QWidget(parent)
{

	initItem();
	setText(txt);
	setBrush(br);
}

LegendItem::~LegendItem()
{

	delete ltxt;
	delete limg;
	delete layout;
}


void
LegendItem::initItem()
{

	layout = new QHBoxLayout(this);
	MARGINS_ZERO(layout);

	limg = new QLabel(this);
	limg->setAttribute(Qt::WA_StaticContents);
	layout->addWidget(limg, 0, Qt::AlignLeft | Qt::AlignVCenter);

	ltxt = new QLabel(this);
	layout->addWidget(ltxt, 1);
}


void
LegendItem::setText(const QString &txt)
{

	ltxt->setText(txt);
}


void
LegendItem::setBrush(const QBrush &brush)
{
	QImage		*img;
	QPainter	*p;
	int		wdt = fontMetrics().height() * 4 / 5;

	img = new QImage(wdt, wdt, QImage::Format_ARGB32_Premultiplied);
	p = new QPainter(img);

	p->setBrush(brush);
	p->setPen(Qt::black);
	p->drawRect(0, 0, wdt - 1, wdt - 1);

	delete p;
	limg->setPixmap(QPixmap::fromImage(*img));
	delete img;
}

/* EOF */
