/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: mainwindow.cpp,v 1.13 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "mainwindow.h"
#include "workspace.h"
#include "settings.h"


MainWindow::MainWindow(Settings *ptr, QWidget *parent)
	:QMainWindow(parent), hasTranslator(ptr->hasTranslation()),
	server(NULL)
{

	setWindowTitle(tr("%1 by %2").arg(QCoreApplication::applicationName())
		.arg(QCoreApplication::organizationName()));

	wrk = new Workspace(ptr, &server, this);
	connect(wrk, SIGNAL(message(const QString&)),
		this, SLOT(showMessage(const QString&)));
	setCentralWidget(wrk);

	initMenu();
	showMessage(QString::null);
}

MainWindow::~MainWindow()
{

	delete wrk;
	destroyMenu();
}


void
MainWindow::initMenu()
{

	admin = new QMenu(tr("Administrator"), this);
	admin->addAction(QIcon(":/icons/manager.png"),
		tr("Servers and accounts"),
		wrk, SLOT(serverList()), Qt::CTRL | Qt::Key_L);
	admin->addAction(QIcon(":/icons/plugin.png"), tr("Plugins"),
		wrk, SLOT(pluginList()), Qt::ALT | Qt::Key_P);
	admin->addSeparator();

	admin->addAction(QIcon(":/icons/quit.png"), tr("Quit"),
		qApp, SLOT(quit()), QKEYSEQUENCE_QUIT);

	server = new QMenu(tr("Server"), this);
	connect(server, SIGNAL(triggered(QAction *)),
		wrk, SLOT(raiseServer(QAction *)));

	help = new QMenu(tr("Help"), this);
	help->addAction(tr("About"), this, SLOT(about()));
	help->addAction(tr("About Qt"), this, SLOT(aboutQt()));

	menuBar()->addMenu(admin);
	menuBar()->addMenu(server);
	menuBar()->addSeparator();
	menuBar()->addMenu(help);
}


void
MainWindow::destroyMenu()
{

	delete help;
	delete server;
	delete admin;
}


void
MainWindow::about()
{
	QMyAdminAbout	*about;

	about = new QMyAdminAbout(hasTranslator, this);
	about->exec();
	delete about;
}


void
MainWindow::aboutQt()
{

	QMessageBox::aboutQt(this, QCoreApplication::applicationName());
}


void
MainWindow::showMessage(const QString &msg)
{

	if (msg.isEmpty())
		statusBar()->showMessage(tr("Ready"));
	else
		statusBar()->showMessage(msg);
}

//-----------------------------------------------------------------------------

QMyAdminAbout::QMyAdminAbout(bool atr, QWidget *parent)
	:QMessageBox(parent)
{

	setWindowTitle(tr("About %1")
		.arg(QCoreApplication::applicationName()));

	setText(tr("This program was designed to manage some local MariaDB "
		"servers<br>"
		"Developed at <a href=\"http://www.tstu.ru/\">Tambov State "
		"Technical University</a><br>"
		"Suggestions and comments may be sent to "
		"<a href=\"mailto:denis@silversoft.net\">my E-mail "
		"address</a> in Russian or English and don't forget to "
		"specify the subject «QMyAdmin»"));
	if (atr != TRUE) {
		/* no translation, add about Emm ;-) */
		setInformativeText("Special thanks to Emmanuel Glykokalamos "
			"for English correction ;-)");
	}
	setIconPixmap(QPixmap(":/icons/logo.gif"));
}

QMyAdminAbout::~QMyAdminAbout()
{
}

/* EOF */
