/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: plugin_editor.cpp,v 1.2 2013/07/30 13:37:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "plugin_editor.h"
#include "settings.h"
#include "plugin_list.h"

#define	BUTTONS		QDialogButtonBox::Close


PluginEditor::PluginEditor(PluginData *ptr, QWidget *parent)
	:QWidget(parent), vect(ptr)
{

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	list = new PluginList(ptr, this);
	connect(list, SIGNAL(changed()), this, SLOT(dataChanged()));
	connect(list, SIGNAL(loaded(QPluginLoader *)),
		SIGNAL(loaded(QPluginLoader *)));
	layout->addWidget(list, 1);

	dlg = new QDialogButtonBox(BUTTONS, Qt::Horizontal, this);
	connect(dlg, SIGNAL(rejected()), SIGNAL(reject()));
	layout->addWidget(dlg, 0, Qt::AlignBottom);

	load = new QPushButton(QIcon(":/icons/plugin-add.png"),
		tr("Load"), this);
	dlg->addButton(load, QDialogButtonBox::ActionRole);
	connect(load, SIGNAL(clicked()), list, SLOT(loadPlugin()));

	unload = new QPushButton(QIcon(":/icons/plugin-delete.png"),
		tr("Unload"), this);
	dlg->addButton(unload, QDialogButtonBox::ActionRole);
	connect(unload, SIGNAL(clicked()), list, SLOT(unloadPlugin()));

	dataChanged();
}

PluginEditor::~PluginEditor()
{

	delete unload;
	delete load;
	delete dlg;
	delete list;
	delete layout;
}


void
PluginEditor::dataChanged()
{
	bool	ena = !list->isEmpty();

	unload->setEnabled(ena);
}

/* EOF */
