/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: plugin_list.cpp,v 1.2 2013/07/30 13:37:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "plugin_list.h"
#include "settings.h"
#include "plugin_model.h"
#include "sql_service.h"


PluginList::PluginList(PluginData *ptr, QWidget *parent)
	:QWidget(parent)
{

	model = new PluginModel(ptr);
	connect(model, SIGNAL(loaded(QPluginLoader *)),
		SIGNAL(loaded(QPluginLoader *)));

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	view = new QTableView(this);
	view->setModel(model);
	layout->addWidget(view, 1);

	TABLE_VIEW_INIT(view);
	selectItem(FALSE);
}

PluginList::~PluginList()
{

	delete view;
	delete layout;
	delete model;
}


void
PluginList::loadPlugin()
{
	QString	file(QFileDialog::getOpenFileName(this,
		tr("Select a plugin to load"), PLUGINDIR, "*"PLUGIN_EXT));

	if (!file.isEmpty()) {
		model->loadPlugin(file, this);
		selectItem(TRUE);
	}
}


void
PluginList::unloadPlugin()
{
	QModelIndex	ndx(view->currentIndex());
	QPluginLoader	*plg = model->plugin(ndx);
	ServicePlugin	*srv;
	QString		name;
	Confirm		q, w;

	if ((plg == NULL) || ((srv = PLUGIN_CAST(plg)) == NULL))
		Core::noData(this);
	else {
		name = srv->name();
		q.title = QString::null;
		q.text = tr("Do you want to unload plugin %1?")
			.arg(name);
		w.title = QString::null;
		w.text = tr("After unloading some features will be "
			"unavailable until you load it again.\n"
			"Unload it anyway?");
		if (Core::doubleConfirm(q, w, this)) {
			model->unloadPlugin(ndx);
			selectItem(TRUE);
		}
	}
}


bool
PluginList::isEmpty()const
{

	return (model->isEmpty());
}


void
PluginList::selectItem(bool sig)
{
	QItemSelectionModel	*sel = view->selectionModel();

	if ((sel != NULL) && !sel->hasSelection())
		view->setCurrentIndex(model->index(0, 0));

	if (sig)
		emit changed();
}

/* EOF */
