/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: plugin_list.h,v 1.2 2013/07/30 13:37:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Plugin view from a model
 */

#ifndef __PLUGIN_LIST_H__
#define __PLUGIN_LIST_H__

#include "gui.h"

class PluginData;
class PluginModel;

class PluginList:public QWidget
{
	Q_OBJECT
public:
	PluginList(PluginData *, QWidget *parent = NULL);
	~PluginList();

	bool	isEmpty()const;

private:
	PluginModel	*model;
	QVBoxLayout	*layout;
	QTableView	*view;

	void	selectItem(bool sig = TRUE);

public slots:
	void	loadPlugin();
	void	unloadPlugin();

signals:
	void	changed();
	void	loaded(QPluginLoader *);
};

#endif  /* __PLUGIN_LIST_H__ */

/* EOF */
