/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: plugin_model.cpp,v 1.2 2013/07/30 13:37:47 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "plugin_model.h"
#include "settings.h"
#include "sql_service.h"

#define	LAB_NAME	0
#define	LAB_FILE	1
#define	LAB_DESC	2
#define	LAB_TOTAL	(LAB_DESC + 1)


PluginModel::PluginModel(PluginData *ptr, QObject *parent)
	:QAbstractTableModel(parent), vect(ptr)
{
}

PluginModel::~PluginModel()
{
}


QVariant
PluginModel::data(const QModelIndex &ndx, int role)const
{
	QVariant	ret;
	QPluginLoader	*plg = vect->at(ndx.row());

	if (plg != NULL)
		switch (role) {
			case Qt::DisplayRole:
				ret = displayData(plg, ndx.column());
				break;
		}

	return (ret);
}


QVariant
PluginModel::headerData(int sct, Qt::Orientation ort, int role)const
{
	QVariant	ret;

	if ((ort == Qt::Horizontal) && (role == Qt::DisplayRole))
		switch (sct) {
			case LAB_NAME:
				ret = tr("Name");
				break;
			case LAB_FILE:
				ret = tr("File");
				break;
			case LAB_DESC:
				ret = tr("Description");
				break;
		}

	return (ret);
}


int
PluginModel::columnCount(const QModelIndex&)const
{

	return (LAB_TOTAL);
}


int
PluginModel::rowCount(const QModelIndex&)const
{

	return (vect->size());
}


void
PluginModel::loadPlugin(const QString &file, QWidget *parent)
{
	QPluginLoader	*plg, *tmp;
	ServicePlugin	*srv;
	QString		error, name;
	unsigned int	pos;

	if (!QLibrary::isLibrary(file))
		QMessageBox::information(parent, tr("Library error"),
			tr("The file %1 is not a library, cannot load it")
			.arg(file));
	else {
		plg = PluginData::load(file, &error);
		if (plg != NULL) {
			srv = PLUGIN_CAST(plg);
			name = srv->name();
			if ((tmp = vect->lookup(name)) != NULL) {
				plg->unload();
				delete plg;
				QMessageBox::information(parent,
					tr("Plugin exists"),
					tr("Plugin %1 is already loaded "
					"from file %2\n"
					"New copy of this plugin is unloaded")
					.arg(name).arg(tmp->fileName()));
			} else {
				pos = vect->findPosition(srv->name());
				beginInsertRows(QModelIndex(), pos, pos);
				vect->insert(pos, plg);
				endInsertRows();
				emit loaded(plg);
			}
		} else {
			QMessageBox::information(parent, tr("Plugin error"),
				tr("Cannot load file %1 as a plugin,\n"
				"%2").arg(file).arg(error));
		}
	}
}


void
PluginModel::unloadPlugin(const QModelIndex &ndx)
{
	int	pos = ndx.row();

	beginRemoveRows(QModelIndex(), pos, pos);
	vect->remove(pos);
	endRemoveRows();
}


QVariant
PluginModel::displayData(QPluginLoader *plg, int column)const
{
	QVariant	ret;
	ServicePlugin	*srv = PLUGIN_CAST(plg);

	switch (column) {
		case LAB_NAME:
			ret = srv->name();
			break;
		case LAB_FILE:
			ret = QFileInfo(plg->fileName()).fileName();
			break;
		case LAB_DESC:
			ret = srv->description();
			break;
	}

	return (ret);
}


QPluginLoader *
PluginModel::plugin(const QModelIndex &ndx)const
{

	return (vect->at(ndx.row()));
}


bool
PluginModel::isEmpty()const
{

	return (vect->isEmpty());
}

/* EOF */
