/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: settings.h,v 1.4 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SETTINGS_H__
#define __SETTINGS_H__

#include "gui.h"
#include "sql_account.h"

#define	PLUGIN_CAST(plg)						\
	qobject_cast<ServicePlugin *>((plg)->instance())

typedef	QVector<QPluginLoader *>	PluginVector;
typedef	QMap<QString, QPluginLoader *>	PluginMap;


class PluginData
{
public:
	PluginData();
	~PluginData();

	void	insert(unsigned int, QPluginLoader *);
	void	save(QSettings&);
	void	remove(unsigned int);

	bool		isEmpty()const;
	int		size()const;
	unsigned int	findPosition(const QString&)const;
	QPluginLoader	*at(unsigned int);
	bool		load(QSettings&);
	QPluginLoader	*lookup(const QString&);

	operator PluginVector*();

	static QPluginLoader	*load(const QString&, QString *error = NULL);

private:
	PluginVector	vect;
	PluginMap	map;

	void	destroyVector();
};

//-----------------------------------------------------------------------------

class Settings
{
public:
	Settings();
	~Settings();

	void	load();
	void	save();
	void	setGeometry(const QRect&);
	void	setTranslation(bool);

	QRect	geometry()const;
	bool	hasTranslation()const;

	operator SqlAccountVector*();
	operator PluginData*();

private:
	SqlAccountVector	vect;
	PluginData		plg_list;
	QRect			geom;	/* geometry of the main window */
	bool			p_tr;	/* TRUE, if app translator is loaded */

	void	destroyVector();
	void	loadServers(QSettings&);
	void	loadPlugins(QSettings&);
	void	loadGeometry(QSettings&);
	void	saveServers(QSettings&);
	void	savePlugins(QSettings&);
	void	saveGeometry(QSettings&);
};

#endif  /* __SETTINGS_H__ */

/* EOF */
