/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_account.cpp,v 1.3 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_account.h"

#define	CFG_SERVICE	"service"


SqlAccount::SqlAccount(QObject *parent)
	:QObject(parent), SqlConfig(), acc_status(0), p_srv(QString::null)
{
}

SqlAccount::SqlAccount(const SqlAccount &acc)
	:QObject(NULL), SqlConfig()
{

	setAccount(acc);
}


SqlAccount::~SqlAccount()
{

	closeConnection();
}


void
SqlAccount::setAccount(const SqlAccount &acc)
{

	setConfig(acc);
	acc_status = acc.status();
	setService(acc.service());
}


void
SqlAccount::setStatus(flags_t stat, bool on)
{

	if (stat != 0) {
		if (on)
			acc_status |= stat;
		else
			acc_status &= (~stat);
	}
}


void
SqlAccount::setService(const QString &srv)
{

	p_srv = srv;
}


void
SqlAccount::save(QSettings &cfg)
{

	cfg.setValue(CFG_SERVICE, service());
	SqlConfig::save(cfg);
}


bool
SqlAccount::load(QSettings &cfg)
{

	setService(cfg.value(CFG_SERVICE, QVariant(QString::null)).toString());

	return (SqlConfig::load(cfg));
}


flags_t
SqlAccount::status()const
{

	return (acc_status);
}


QString
SqlAccount::service()const
{

	return (p_srv);
}


bool
SqlAccount::hasStatus(flags_t stat)const
{

	return ((status() & stat) != 0);
}


bool
SqlAccount::hasPassword()const
{

	return (!password().isEmpty());
}


SqlAccount&
SqlAccount::operator=(const SqlAccount &acc)
{

	setAccount(acc);

	return (*this);
}


void
SqlAccount::closeConnection()
{

	if (hasStatus(ACC_CONNECTED))
		emit close();
}


/* EOF */
