/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_account.h,v 1.3 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_ACCOUNT_H__
#define __SQL_ACCOUNT_H__

#include "sql_config.h"

#define	ACC_CONNECTED	0x01	/* this account is in use (connected) */

class SqlAccount;
typedef	QMap<QString, SqlAccount *>	SqlAccountMap;
typedef	QVector<SqlAccount *>		SqlAccountVector;


class SqlAccount:public QObject, public SqlConfig
{
	Q_OBJECT
public:
	SqlAccount(QObject *parent = NULL);
	SqlAccount(const SqlAccount&);
	~SqlAccount();

	void	setAccount(const SqlAccount&);
	void	setStatus(flags_t, bool);
	void	setService(const QString&);
	void	save(QSettings&);

	bool	load(QSettings&);
	flags_t	status()const;
	QString	service()const;
	bool	hasStatus(flags_t)const;
	bool	hasPassword()const;

	SqlAccount&	operator=(const SqlAccount&);

private:
	flags_t	acc_status;
	QString	p_srv;		/* last service */

public slots:
	void	closeConnection();

signals:
	void	close();
};

#endif  /* __SQL_ACCOUNT_H__ */

/* EOF */
