/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_account_editor.cpp,v 1.8 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_account_editor.h"

#define	BUTTONS		QDialogButtonBox::Close


SqlAccountEditor::SqlAccountEditor(SqlAccountVector *ptr, QWidget *parent)
	:QWidget(parent), vect(ptr)
{

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	list = new SqlAccountList(vect, this);
	connect(list, SIGNAL(changed()), this, SLOT(dataChanged()));
	connect(list, SIGNAL(connection(bool)),
		this, SLOT(setConnection(bool)));
	connect(list, SIGNAL(doConnection(SqlAccount *)),
		SIGNAL(doConnection(SqlAccount *)));
	layout->addWidget(list, 1);

	legend = Core::accountLegend(this);
	layout->addWidget(legend);

	dlg = new QDialogButtonBox(BUTTONS, Qt::Horizontal, this);
	connect(dlg, SIGNAL(rejected()), SIGNAL(reject()));
	layout->addWidget(dlg, 0, Qt::AlignBottom);

	con = new QPushButton(this);
	connect(con, SIGNAL(clicked()), list, SLOT(connectAccount()));
	dlg->addButton(con, QDialogButtonBox::ActionRole);

	add = new QPushButton(QIcon(":/icons/add.png"),
		Core::text(Core::Add), this);
	connect(add, SIGNAL(clicked()), list, SLOT(addAccount()));
	dlg->addButton(add, QDialogButtonBox::ActionRole);

	edt = new QPushButton(QIcon(":/icons/edit.png"),
		Core::text(Core::Edit), this);
	connect(edt, SIGNAL(clicked()), list, SLOT(editAccount()));
	dlg->addButton(edt, QDialogButtonBox::ActionRole);

	del = new QPushButton(QIcon(":/icons/delete.png"),
		Core::text(Core::Delete), this);
	connect(del, SIGNAL(clicked()), list, SLOT(delAccount()));
	dlg->addButton(del, QDialogButtonBox::ActionRole);

	dataChanged();
	setConnection(list->isConnected());
}

SqlAccountEditor::~SqlAccountEditor()
{

	delete del;
	delete edt;
	delete add;
	delete con;
	delete dlg;
	delete legend;
	delete list;
	delete layout;
}


void
SqlAccountEditor::dataChanged()
{
	bool	emp = vect->empty();

	del->setDisabled(emp);
	edt->setDisabled(emp);
	con->setDisabled(emp);
}


void
SqlAccountEditor::setConnection(bool conn)
{
	static QIcon	connected(":/icons/connection.png"),
			disconnected(":/icons/disconnected.png");
	static QString	c_text(tr("Connect")),
			d_text(tr("Disconnect"));
	const QIcon	*icon;
	const QString	*text;

	if (conn) {
		icon = &disconnected;
		text = &d_text;
	} else {
		icon = &connected;
		text = &c_text;
	}

	con->setIcon(*icon);
	con->setText(*text);
}


void
SqlAccountEditor::accountChanged(SqlAccount *acc)
{

	list->accountChanged(acc);
	setConnection(list->isConnected());
}

/* EOF */
