/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_account_editor.h,v 1.6 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_ACCOUNT_EDITOR_H__
#define __SQL_ACCOUNT_EDITOR_H__

#include "gui.h"
#include "sql_account_list.h"


class SqlAccountEditor:public QWidget
{
	Q_OBJECT
public:
	SqlAccountEditor(SqlAccountVector *, QWidget *parent = NULL);
	~SqlAccountEditor();

	void	accountChanged(SqlAccount *);

private:
	SqlAccountVector	*vect;
	QVBoxLayout		*layout;
	SqlAccountList		*list;
	QWidget			*legend;
	QDialogButtonBox	*dlg;
	QPushButton		*add;
	QPushButton		*edt;
	QPushButton		*del;
	QPushButton		*con;

private slots:
	void	dataChanged();
	void	setConnection(bool);

signals:
	void	reject();
	void	doConnection(SqlAccount *);
};

#endif  /* __SQL_ACCOUNT_EDITOR_H__ */

/* EOF */
