/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_account_legend.cpp,v 1.1 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_account_legend.h"
#include "legend_item.h"


SqlAccountLegend::SqlAccountLegend(QWidget *parent)
	:QGroupBox(tr("Color legend"), parent)
{

	setAlignment(Qt::AlignHCenter);

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	li_conn = new LegendItem(BRUSH_CONNECTED,
		tr("Connection is in use"), this);
	layout->addWidget(li_conn);

	li_norm = new LegendItem(palette().brush(QPalette::Window),
		tr("The connection has admissible security"), this);
	layout->addWidget(li_norm);

	li_mid = new LegendItem(BRUSH_MID_SECURITY,
		tr("The connection has medium security"), this);
	layout->addWidget(li_mid);

	li_low = new LegendItem(BRUSH_LOW_SECURITY,
		tr("The connection has low security"), this);
	layout->addWidget(li_low);

	li_nosec = new LegendItem(BRUSH_NO_SECURITY,
		tr("The connection has no security at all (very BAD!)"), this);
	layout->addWidget(li_nosec);
}

SqlAccountLegend::~SqlAccountLegend()
{

	delete li_nosec;
	delete li_low;
	delete li_mid;
	delete li_norm;
	delete li_conn;
	delete layout;
}

/* EOF */
