/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_account_list.cpp,v 1.6 2013/07/31 13:41:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_account_list.h"
#include "sql_config_dialog.h"


SqlAccountList::SqlAccountList(SqlAccountVector *vect, QWidget *parent)
	:QWidget(parent)
{
	QItemSelectionModel	*smodel;

	model = new SqlAccountModel(vect, this);
	connect(model, SIGNAL(actionConnect(SqlAccount *)),
		SIGNAL(doConnection(SqlAccount *)));

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	view = new QTableView(this);
	layout->addWidget(view, 1);
	view->setModel(model);
	connect(view, SIGNAL(doubleClicked(const QModelIndex&)),
		this, SLOT(editAccount(const QModelIndex&)));

	TABLE_VIEW_INIT(view);

	smodel = view->selectionModel();
	connect(smodel,
		SIGNAL(currentChanged(const QModelIndex&, const QModelIndex&)),
		this,
		SLOT(accountSelected(const QModelIndex&, const QModelIndex&)));

	selectItem(FALSE);
}

SqlAccountList::~SqlAccountList()
{

	delete model;
	delete view;
	delete layout;
}


/* Creates dialog to input a new account */
void
SqlAccountList::addAccount()
{
	SqlConfigDialog	*dlg;
	SqlAccount	acc, *ptr;

	dlg = new SqlConfigDialog(this);
	FATAL(dlg == NULL);
	dlg->setWindowTitle(tr("New server to manage") + WIN_MOD_AFTER);

	for (;;) {
		if (dlg->exec()) {
			/* save new data */
			dlg->config(acc);
			if (model->exists(acc)) {
				if (QMessageBox::question(this,
					tr("Account exists"), tr("The account "
					"%1 is already in the list.\n"
					"Do you want to rewrite it?")
					.arg(acc.account()),
					QMessageBox::Yes | QMessageBox::Cancel,
					QMessageBox::Cancel) ==
					QMessageBox::Yes) {
					/* rewrite */
					ptr = model->remove(acc);
					FATAL(ptr == NULL);
					/* FIXME: а вдруг он соединился? */
					delete ptr;
					goto HAXEP;
				} else if (QMessageBox::question(this,
					tr("Account edit"),
					tr("Do you want to continue edition "
					"or to discard it?"),
					QMessageBox::Ok | QMessageBox::Discard,
					QMessageBox::Ok) == QMessageBox::Ok)
					continue;
			} else {
				HAXEP:
				model->insert(acc);
				selectItem();
			}
		}
		break;
	}

	delete dlg;
}


/* Removes an account from the list */
void
SqlAccountList::delAccount()
{
	SqlAccount	*ptr = model->account(view->currentIndex());
	Confirm		q, w;

	if (ptr == NULL)
		Core::noData(this);
	else {
		q.title = QString::null;
		q.text = tr("Do you want to delete account %1 from the list?")
			.arg(ptr->account());
		w.title = QString::null;
		w.text = tr("Are you absolutely sure that I should complete "
			"this action?\nIf you are faulted now, "
			"you need to fill it all once again!\n"
			"Continue anyway?");
		if (Core::doubleConfirm(q, w, this)) {
			model->remove(*ptr);
			delete ptr;
			selectItem(TRUE);
		}
	}
}


/* Edit current account */
void
SqlAccountList::editAccount()
{

	editAccount(view->currentIndex());
}


/* Edit specified account */
void
SqlAccountList::editAccount(const QModelIndex &ndx)
{
	SqlAccount	acc, *ptr = model->account(ndx), *tmp;
	SqlConfigDialog	*dlg;

	if (ptr == NULL)
		Core::noData(this);
	else {
		dlg = new SqlConfigDialog(this);
		FATAL(dlg == NULL);
		dlg->setWindowTitle(tr("Change account properties") +
			WIN_MOD_AFTER);
		dlg->setConfig(*ptr);

		if (dlg->exec() && dlg->isWindowModified()) {
			dlg->config(acc);
			tmp = model->account(acc);
			if (ptr == tmp) {
				/*
				 * some properties changed,
				 * but not the account
				 */
				ptr->setAccount(acc);
			} else {
				/*
				 * FIXME: какая-то жопа, но ещё не понял
				 * как здесь правильней сделать
				 */
				/* account changed */
				model->remove(*ptr);
				delete ptr;
				model->insert(acc);
			}
			selectItem(TRUE);
		}

		delete dlg;
	}
}


void
SqlAccountList::accountSelected(const QModelIndex &ndx, const QModelIndex&)
{
	SqlAccount	*ptr = model->account(ndx);

	if (ptr != NULL)
		emit connection(ptr->hasStatus(ACC_CONNECTED));
}


void
SqlAccountList::connectAccount()
{
	QModelIndex	ndx(view->currentIndex());

	model->doConnection(ndx);
	accountSelected(ndx, QModelIndex());
}


void
SqlAccountList::selectItem(bool sig)
{
	QItemSelectionModel	*sel = view->selectionModel();

	if ((sel != NULL) && !sel->hasSelection())
		view->setCurrentIndex(model->index(0, 0));

	if (sig)
		emit changed();
}


bool
SqlAccountList::isConnected()const
{
	SqlAccount	*ptr = model->account(view->currentIndex());
	bool		ret;

	if (ptr != NULL)
		ret = ptr->hasStatus(ACC_CONNECTED);
	else
		ret = FALSE;

	return (ret);
}


void
SqlAccountList::accountChanged(SqlAccount *acc)
{

	model->accountChanged(acc);
}

/* EOF */
