/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_account_list.h,v 1.4 2013/07/31 13:41:36 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_ACCOUNT_LIST_H__
#define __SQL_ACCOUNT_LIST_H__

#include "gui.h"
#include "sql_account_model.h"


class SqlAccountList:public QWidget
{
	Q_OBJECT
public:
	SqlAccountList(SqlAccountVector *, QWidget *parent = NULL);
	~SqlAccountList();

	void	accountChanged(SqlAccount *);

	bool	isConnected()const;

private:
	QVBoxLayout	*layout;
	QTableView	*view;
	SqlAccountModel	*model;

	void	selectItem(bool sig = TRUE);

public slots:
	void	addAccount();
	void	delAccount();
	void	editAccount();
	void	connectAccount();

private slots:
	void	editAccount(const QModelIndex&);
	void	accountSelected(const QModelIndex&, const QModelIndex&);

signals:
	void	changed();
	void	connection(bool);
	void	doConnection(SqlAccount *);
};

#endif  /* __SQL_ACCOUNT_LIST_H__ */

/* EOF */
