/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_config_widget.h,v 1.6 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Classes to input SQL connection data
 */

#ifndef __SQL_CONFIG_WIDGET_H__
#define __SQL_CONFIG_WIDGET_H__

#include "gui.h"
#include "sql_config.h"


class SqlConfigFlags:public QGroupBox
{
	Q_OBJECT
public:
	SqlConfigFlags(QWidget *parent = NULL);
	~SqlConfigFlags();

	void	flags(SqlConfig&);
	void	setFlags(const SqlConfig&);

	bool	sslIsChecked()const;
	bool	askIsChecked()const;

private:
	QVBoxLayout	*layout;
	QCheckBox	*reconnect;
	QCheckBox	*compress;
	QCheckBox	*ssl;
	QCheckBox	*alogin;
	QCheckBox	*askLogin;

signals:
	void	sslClicked(bool);
	void	askClicked(bool);
	void	changed();
};

//-----------------------------------------------------------------------------

class FileChooser:public QWidget
{
	Q_OBJECT
public:
	FileChooser(const QString&, QFileDialog::Options,
		QWidget *parent = NULL);
	~FileChooser();

	void	setText(const QString&);

	QString	text()const;

private:
	QString			title;
	QFileDialog::Options	opt;
	QHBoxLayout		*layout;
	QLabel			*labFile;
	QPushButton		*chooser;

private slots:
	void	chooseFile();

signals:
	void	changed();
};

//-----------------------------------------------------------------------------

class SqlConfigSSL:public QGroupBox
{
	Q_OBJECT
public:
	SqlConfigSSL(QWidget *parent = NULL);
	~SqlConfigSSL();

	void	ssl(SqlConfig&);
	void	setSSL(const SqlConfig&);

private:
	QFormLayout	*layout;
	FileChooser	*sslKey;
	FileChooser	*sslCert;
	FileChooser	*sslCA;
	FileChooser	*sslCaPath;
	QLineEdit	*sslCipher;

private slots:
	void	dataChanged(const QString&);

signals:
	void	changed();
};

//-----------------------------------------------------------------------------

class SqlConfigWidget:public QWidget
{
	Q_OBJECT
public:
	SqlConfigWidget(QWidget *parent = NULL);
	~SqlConfigWidget();

	void	config(SqlConfig&);
	void	setConfig(const SqlConfig&);

	bool	canAccept()const;
	bool	hasUser()const;
	bool	hasPassword()const;

private:
	QVBoxLayout	*layout;
	QFormLayout	*form;
	QLineEdit	*hostEdit;
	QLineEdit	*userEdit;
	QLineEdit	*passEdit;
	QSpinBox	*portEdit;
	QSpinBox	*readEdit;
	QSpinBox	*writeEdit;
	QSpinBox	*connEdit;
	SqlConfigFlags	*flagsForm;
	SqlConfigSSL	*sslForm;

private slots:
	void	dataChanged(const QString&);
	void	dataChanged(bool);
	void	askChanged(bool);

signals:
	void	changed();
};

#endif  /* __SQL_CONFIG_WIDGET_H__ */

/* EOF */
