/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_connection_private.h,v 1.14 2013/09/19 12:40:38 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_CONNECTION_PRIVATE_H__
#define __SQL_CONNECTION_PRIVATE_H__

#include <mysql.h>

#include "gui.h"
#include "sql_config.h"
#include "sql_error.h"
#include "sql_privileges_flags.h"
#include "sql_connection.h"


class SqlConnection;
class SqlQuery_Private;
class SqlQueue;
class SqlPrivilegesFlags;
typedef	QMap<unsigned int, SqlQuery_Private *>	SqlQueryMap;


class SqlConnection_Private:public QObject
{
	Q_OBJECT
public:
	SqlConnection_Private(SqlConnection *, QObject *parent = NULL);
	~SqlConnection_Private();

	void	close();
	void	startConnection(const SqlConfig *);
	void	startConnection();
	void	removeQuery(unsigned int);
	void	exec(SqlQuery_Private *);
	void	close(MYSQL_STMT *);

	SqlError	exec(MYSQL_STMT *);
	SqlError	exec(const QByteArray&);
	bool		tryConnection(const SqlConfig&, SqlError&);
	unsigned int	insertQuery(SqlQuery_Private *);
	MYSQL_STMT	*createStmt();
	int		prepare(MYSQL_STMT *, const QByteArray&);
	quint64		checksum(const QString&);
	quint64		checksum(GrantInfo::Type);
	SqlError	refresh(unsigned int);
	SqlError	shutdown();
	unsigned long	threadId();
	SqlConnection	*connection()const;
	SqlError	kill(unsigned long);
	QString		account();
	unsigned long	serverVersion();
	int		size();
	SqlPrivilegesMap	privileges(const GrantInfo&);

private:
	SqlConnection	*conn;
	QTimer		*timer;
	MYSQL		*mysql;
	QMutex		mtx_cfg, mtx_conn, mtx_stat;
	QWaitCondition	cnd_stat;
	SqlConfig	config;
	int		status;
	SqlQueryMap	map;
	SqlQueue	*queue;
	unsigned int	next_id;
	QString		my_acc;

	void	setOptions(MYSQL *, const SqlConfig&);
	void	getError(SqlError&, MYSQL *);
	void	getError(SqlError&, MYSQL_STMT *);
	void	errorActions(const SqlError&);
	void	loadGlobalPrivileges(SqlPrivilegesMap&, const GrantInfo&);
	void	loadDatabasePrivileges(SqlPrivilegesMap&, const GrantInfo&);
	void	loadTablePrivileges(SqlPrivilegesMap&, const GrantInfo&);
	void	loadColumnPrivileges(SqlPrivilegesMap&, const GrantInfo&);
	void	loadProcPrivileges(SqlPrivilegesMap&, const GrantInfo&);
	void	parsePrivileges(SqlPrivilegesFlags&, const QString&);

	MYSQL		*createConnection(const SqlConfig&, SqlError&);
	unsigned int	createId();
	SqlPrivilegesFlags::ProcType	procType(const QString&)const;

private slots:
	void	doConnect();
	void	readQueue();

signals:
	void	connected();
	void	closed();
	void	error(const SqlError&);
};

//-----------------------------------------------------------------------------

class SqlQueue
{
public:
	SqlQueue();
	~SqlQueue();

	void	insert(SqlQuery_Private *);

	SqlQuery_Private	*query();
	int			size();

private:
	QQueue<SqlQuery_Private *>	queue;
	QMutex				mtx;
	QWaitCondition			cnd;
};

#endif  /* __SQL_CONNECTION_PRIVATE_H__ */

/* EOF */
