/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_error.cpp,v 1.7 2013/10/30 07:20:44 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_error.h"

SqlError::SqlError()
{

	clear();
}

SqlError::SqlError(int errcode, const QString &error)
{

	setError(errcode, error);
}

SqlError::SqlError(const SqlError &err)
{

	setError(err);
}

SqlError::~SqlError()
{

}


void
SqlError::clear()
{

	setError(0, QString::null);
}


void
SqlError::setError(int errcode, const QString &error)
{

	sql_errno = errcode;
	sql_error = error;
}


void
SqlError::setError(const SqlError &err)
{

	setError(err.errcode(), err.error());
}


void
SqlError::show(QWidget *parent)const
{

	QMessageBox::critical(parent, QObject::tr("Sql error"),
		QObject::tr("Error %1\n%2").arg(errcode()).arg(error()));
}


int
SqlError::errcode()const
{

	return (sql_errno);
}


QString
SqlError::error()const
{

	return (sql_error);
}


SqlError&
SqlError::operator=(const SqlError &err)
{

	setError(err);

	return (*this);
}


bool
SqlError::operator==(int code)const
{

	return (errcode() == code);
}


bool
SqlError::operator!=(int code)const
{

	return (errcode() != code);
}


SqlError::operator QString()const
{

	return (error());
}


void
SqlError::registerMeta()
{

	qRegisterMetaType<SqlError>("SqlError");
}


//-----------------------------------------------------------------------------

ostream&
operator<<(ostream &str, const SqlError &err)
{
	int	code = err.errcode();

	str<<"Error: "<<code<<endl;
	if (code != 0) {
		str<<err.error();
		abort();
	} else
		str<<"No errors";

	return (str);
}

/* EOF */
