/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_privileges_flags.cpp,v 1.3 2013/09/19 12:40:38 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_privileges_flags.h"

#define	STRFLAG(flags, flag, strflag, str)	do {			\
	if ((flags) & (flag)) {						\
		if (!(str).isEmpty())					\
			(str) += fsep;					\
		(str) += (strflag);					\
	}								\
} while (0)

static const QString	fsep(", ");


SqlPrivilegesFlags::SqlPrivilegesFlags()
{

	setInternalFlags(PRIV_INITIALIZER);
	setProcType(P_NONE);
}


SqlPrivilegesFlags::SqlPrivilegesFlags(const sql_privileges_t flags)
{

	setInternalFlags(flags);
	setProcType(P_NONE);
}

SqlPrivilegesFlags::SqlPrivilegesFlags(const SqlPrivilegesFlags &flags)
{

	setInternalFlags(flags.flags());
	setProcType(flags.procType());
}

SqlPrivilegesFlags::~SqlPrivilegesFlags()
{

	/* nothing to do here */
}


void
SqlPrivilegesFlags::setFlag(sql_privileges_t flags, bool on)
{

	flags &= PRIV_MASK;
	if (flags > 0) {
		if (on)
			p_flags |= flags;
		else
			p_flags &= ~flags;
	}
}


void
SqlPrivilegesFlags::setProcType(ProcType type)
{

	p_type = type;
}


sql_privileges_t
SqlPrivilegesFlags::flags()const
{

	return (p_flags);
}


bool
SqlPrivilegesFlags::isSet(sql_privileges_t flg)const
{

	return ((flags() & (flg & PRIV_MASK)) > 0);
}


QString
SqlPrivilegesFlags::toString()const
{
	QString	ret;

	STRFLAG(p_flags, PRIV_SELECT, "Select", ret);
	STRFLAG(p_flags, PRIV_INSERT, "Insert", ret);
	STRFLAG(p_flags, PRIV_UPDATE, "Update", ret);
	STRFLAG(p_flags, PRIV_DELETE, "Delete", ret);
	STRFLAG(p_flags, PRIV_CREATE, "Create", ret);
	STRFLAG(p_flags, PRIV_DROP, "Drop", ret);
	STRFLAG(p_flags, PRIV_RELOAD, "Reload", ret);
	STRFLAG(p_flags, PRIV_SHUTDOWN, "Shutdown", ret);
	STRFLAG(p_flags, PRIV_PROCESS, "Process", ret);
	STRFLAG(p_flags, PRIV_FILE, "File", ret);
	STRFLAG(p_flags, PRIV_GRANT, "Grant", ret);
	STRFLAG(p_flags, PRIV_REFERENCES, "References", ret);
	STRFLAG(p_flags, PRIV_INDEX, "Index", ret);
	STRFLAG(p_flags, PRIV_ALTER, "Alter", ret);
	STRFLAG(p_flags, PRIV_SHOW_DB, "ShowDB", ret);
	STRFLAG(p_flags, PRIV_SUPER, "Super", ret);
	STRFLAG(p_flags, PRIV_CREATE_TMP_TABLE, "CreateTmpTable", ret);
	STRFLAG(p_flags, PRIV_LOCK_TABLES, "LockTables", ret);
	STRFLAG(p_flags, PRIV_EXECUTE, "Execute", ret);
	STRFLAG(p_flags, PRIV_REPL_SLAVE, "ReplSlave", ret);
	STRFLAG(p_flags, PRIV_REPL_CLIENT, "ReplClient", ret);
	STRFLAG(p_flags, PRIV_CREATE_VIEW, "CreateView", ret);
	STRFLAG(p_flags, PRIV_SHOW_VIEW, "ShowView", ret);
	STRFLAG(p_flags, PRIV_CREATE_ROUTINE, "CreateRoutine", ret);
	STRFLAG(p_flags, PRIV_ALTER_ROUTINE, "AlterRoutine", ret);
	STRFLAG(p_flags, PRIV_CREATE_USER, "CreateUser", ret);
	STRFLAG(p_flags, PRIV_EVENT, "Event", ret);
	STRFLAG(p_flags, PRIV_TRIGGER, "Trigger", ret);
	STRFLAG(p_flags, PRIV_CREATE_TABLESPACE, "CreateTableSpace", ret);

	return (ret);
}


SqlPrivilegesFlags::ProcType
SqlPrivilegesFlags::procType()const
{

	return (p_type);
}


SqlPrivilegesFlags::operator sql_privileges_t()const
{

	return (flags());
}


SqlPrivilegesFlags&
SqlPrivilegesFlags::operator=(const SqlPrivilegesFlags &flags)
{

	setInternalFlags(flags.flags());
	setProcType(flags.procType());

	return (*this);
}


SqlPrivilegesFlags&
SqlPrivilegesFlags::operator=(const sql_privileges_t flags)
{

	setInternalFlags(flags);

	return (*this);
}


SqlPrivilegesFlags&
SqlPrivilegesFlags::operator+=(const SqlPrivilegesFlags &flags)
{

	setFlag(flags.flags(), TRUE);

	return (*this);
}


SqlPrivilegesFlags&
SqlPrivilegesFlags::operator+=(const sql_privileges_t flags)
{

	setFlag(flags, TRUE);

	return (*this);
}


SqlPrivilegesFlags&
SqlPrivilegesFlags::operator-=(const SqlPrivilegesFlags &flags)
{

	setFlag(flags.flags(), FALSE);

	return (*this);
}


SqlPrivilegesFlags&
SqlPrivilegesFlags::operator-=(const sql_privileges_t flags)
{

	setFlag(flags, FALSE);

	return (*this);
}


bool
SqlPrivilegesFlags::operator==(const SqlPrivilegesFlags &f)const
{

	return (flags() == f.flags());
}


bool
SqlPrivilegesFlags::operator==(const sql_privileges_t f)const
{

	return (isSet(f));
}


bool
SqlPrivilegesFlags::operator!=(const SqlPrivilegesFlags &f)const
{

	return (flags() != f.flags());
}


bool
SqlPrivilegesFlags::operator!=(const sql_privileges_t f)const
{

	return (isSet(f) != TRUE);
}


void
SqlPrivilegesFlags::setInternalFlags(const sql_privileges_t flags)
{

	/* protect our data */
	p_flags = (flags & PRIV_MASK);
}

/* EOF */
