/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_query.cpp,v 1.5 2013/08/28 12:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_query.h"
#include "sql_connection.h"
#include "sql_query_private.h"
#include "sql_connection_private.h"


SqlQuery::SqlQuery(SqlConnection *conn)
{
	SqlConnection_Private	*tmp = *conn;

	priv = new SqlQuery_Private(tmp);
}

SqlQuery::~SqlQuery()
{

	delete priv;
}


void
SqlQuery::connect(QObject *target, const char *member)
{

	QObject::connect(priv, SIGNAL(ready()), target, member);
}


void
SqlQuery::free()
{

	priv->free();
}


void
SqlQuery::prepare(const QString &q)
{

	priv->prepare(q);
}


bool
SqlQuery::next()
{

	return (priv->next());
}


QVariant
SqlQuery::value(unsigned long pos)const
{

	return (priv->value(pos));
}


QVariant
SqlQuery::value(const QString &name)const
{

	return (priv->value(name));
}


SqlConnection *
SqlQuery::connection()const
{

	return (priv->connection());
}


QVariant
SqlQuery::operator[](unsigned long pos)const
{

	return (priv->value(pos));
}


QVariant
SqlQuery::operator[](const QString &name)const
{

	return (priv->value(name));
}


void
SqlQuery::exec()
{

	priv->exec();
}


void
SqlQuery::bind(unsigned long pos, QString &res)
{

	priv->bind(pos, res);
}


QString
SqlQuery::query(const QString &name, Table table, Scope scope)
{
	static QString	ret("select VARIABLE_VALUE from %1 "
				"where VARIABLE_NAME = '%2'");
	QString		tbl;

	switch (scope) {
		case S_GLOBAL:
			tbl = "GLOBAL";
			break;
		case S_SESSION:
			tbl = "SESSION";
			break;
		default:
			return (QString::null);
	}
	tbl += '_';
	switch (table) {
		case T_STATUS:
			tbl += "STATUS";
			break;
		case T_VARIABLES:
			tbl += "VARIABLES";
			break;
		default:
			return (QString::null);
	}

	return (ret.arg(Core::informationSchema(tbl)).arg(name));
}

/* EOF */
