/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_query_private.h,v 1.5 2013/08/01 14:01:08 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_QUERY_PRIVATE_H__
#define __SQL_QUERY_PRIVATE_H__

#include <mysql.h>

#include "gui.h"

#define	CONDITION_TIMEOUT	5

class SqlConnection;
class SqlConnection_Private;
class SqlResult;

class SqlQuery_Private:public QObject
{
	Q_OBJECT
public:
	SqlQuery_Private(SqlConnection_Private *);
	~SqlQuery_Private();

	void	execute();
	void	prepare(const QString&);

	void	exec();
	void	close();
	void	free();
	void	bind(unsigned long, QString&);
	void	setReprepare();

	bool		next();
	QVariant	value(unsigned long)const;
	QVariant	value(const QString&)const;
	SqlConnection	*connection()const;

private:
	SqlConnection_Private	*conn;
	MYSQL_STMT		*stmt;
	SqlResult		*p_result;
	QString			p_query;
	QMutex			mtx;
	QWaitCondition		cnd;
	int			p_status;
	unsigned int		p_id;

	void	bindArray();
	void	reprepare();

	int	fetch();
	int	status();

signals:
	void	ready();
};

#endif  /* __SQL_QUERY_PRIVATE_H__ */

/* EOF */
