/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_server.h,v 1.12 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_SERVER_H__
#define __SQL_SERVER_H__

#include "gui.h"
#include "server_info.h"


class SqlAccount;
class PluginData;
class SqlConnection;
class SqlError;
class SqlQuery;
class BasicStatus;

class SqlServer:public QWidget
{
	Q_OBJECT
public:
	SqlServer(SqlAccount *, PluginData *, QAction *,
		QWidget *parent = NULL);
	~SqlServer();

	void	addPlugin(QPluginLoader *);

	QAction	*action()const;
	QString	lastService()const;

private:
	ServerInfo	info;
	SqlAccount	*account;
	PluginData	*plugins;
	QAction		*srv_act;
	QVBoxLayout	*layout;
	QTabWidget	*tab;
	QTimer		*timer;
	BasicStatus	*status;
	quint64		crc_global;

	void	addStatus();
	void	addPlugins();
	void	windowTimeout();
	void	reloadPrivileges();
	void	privilegesChanged();
	void	setService(const QString&);

private slots:
	void	accountDestroyed();
	void	connected();
	void	closed();
	void	error(const SqlError&);
	void	timeout();
	void	refresh();
	void	shutdown();
	void	closeServer();
	void	windowChanged(int);
	void	reconnect();

signals:
	void	reject(const QWidget *);
	void	changed(SqlAccount *);
};

//-----------------------------------------------------------------------------

class RefreshDialog:public QDialog
{
	Q_OBJECT
public:
	RefreshDialog(QWidget *parent = NULL);
	~RefreshDialog();

	unsigned int	flags()const;

private:
	QVBoxLayout		*layout;
	QCheckBox		*grant;
	QCheckBox		*log;
	QCheckBox		*tables;
	QCheckBox		*hosts;
	QCheckBox		*status;
	QCheckBox		*threads;
	QCheckBox		*slave;
	QCheckBox		*master;
	QDialogButtonBox	*dlg;
};

#endif  /* __SQL_SERVER_H__ */

/* EOF */
