/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_service.cpp,v 1.6 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_service.h"


SqlService::SqlService(ServerInfo *info, const QString &srv)
	:p_info(info), p_service(srv)
{
}

SqlService::~SqlService()
{
}


void
SqlService::destroyIt()
{

	qWarning()<<"Called virtual function destroyIt()"<<endl;
}


void
SqlService::privilegesChanged()
{

#ifdef	QMYADMIN_DEBUG
	qWarning()<<"Called virtual function privilegesChanged()"<<endl;
#endif	/* QMYADMIN_DEBUG */
}


QString
SqlService::service()const
{

	return (p_service);
}


ServerInfo *
SqlService::info()const
{

	return (p_info);
}


SqlConnection *
SqlService::connection()const
{

	return (info()->connection);
}

//-----------------------------------------------------------------------------

ServicePlugin::ServicePlugin(const QString &name, const QString &desc)
{

	p_name = name;
	p_desc = desc;
	qt = NULL;
}

ServicePlugin::~ServicePlugin()
{

	DELETE_TRANSLATOR(qt);
}


void
ServicePlugin::initTranslator(const QString &file)
{

	qt = Core::installTranslator(file);
}


QString
ServicePlugin::description()const
{

	return (p_desc);
}


QString
ServicePlugin::name()const
{

	return (p_name);
}

/* EOF */
