/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_user.cpp,v 1.4 2013/10/07 17:00:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "sql_user.h"


static QString	format(bool);


SqlUser::SqlUser()
{
	QString null(QString::null);

	setUser(null);
	setHost(null);
	setPassword(null);
}

SqlUser::SqlUser(const SqlUser &user)
{

	setUser(user);
}

SqlUser::~SqlUser()
{

}


void
SqlUser::setUser(const SqlUser &user)
{

	setUser(user.user());
	setHost(user.host());
	setPassword(user.password());
}


void
SqlUser::setUser(const QString &u)
{

	p_user = u;
}


void
SqlUser::setHost(const QString &h)
{

	p_host = h;
}


void
SqlUser::setPassword(const QString &p)
{

	p_pass = p;
}


QString
SqlUser::user()const
{

	return (p_user);
}


QString
SqlUser::host()const
{

	return (p_host);
}


QString
SqlUser::password()const
{

	return (p_pass);
}


QString
SqlUser::account(bool quoted)const
{

	return (accountFormat(quoted).arg(user()).arg(host()));
}


bool
SqlUser::isEmpty()const
{

	return (user().isEmpty() && host().isEmpty() && password().isEmpty());
}


QString
SqlUser::account(const QString &user, const QString &host)
{

	return (format(FALSE).arg(user).arg(host));
}


SqlUser
SqlUser::split(const QString &acc)
{
	SqlUser		ret;
	QStringList	list(acc.split("@", QString::SkipEmptyParts));

	if (list.isEmpty()) {
		cout<<acc<<endl;
		abort();
	}
	ret.setUser(list[0]);
	if (list.size() > 1)
		ret.setHost(list[1]);

	return (ret);
}


QString
SqlUser::accountFormat(bool quoted)const
{
	return (format(quoted));
}


SqlUser&
SqlUser::operator=(const SqlUser &usr)
{

	setUser(usr);

	return (*this);
}


bool
SqlUser::operator!=(const SqlUser &u)
{
	bool	reg = TRUE;

	return (account(reg).toLower() != u.account(reg).toLower());
}

//-----------------------------------------------------------------------------

QString
format(bool quoted)
{
	static QString	acc_quoted("`%1`@`%2`"),
			acc_unquoted("%1@%2");
	QString	&ret = quoted?acc_quoted:acc_unquoted;

	return (ret);
}


ostream&
operator<<(ostream &s, const SqlUser &usr)
{

	s<<usr.user()<<'@'<<usr.host();
	if (usr.password().isEmpty())
		s<<" (No)";
	else
		s<<" ("<<usr.password()<<")";
	return (s);
}

/* EOF */
