/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: workspace.h,v 1.7 2013/08/07 11:59:52 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __WORKSPACE_H__
#define __WORKSPACE_H__

#include "gui.h"

class Settings;
class SubWindow;
class SqlAccount;

class Workspace:public QWidget
{
	Q_OBJECT
public:
	Workspace(Settings *, QMenu **, QWidget *parent = NULL);
	~Workspace();

private:
	Settings	*cfg;
	QMenu		**server_ptr;
	QVBoxLayout	*layout;
	QMdiArea	*area;
	SubWindow	*sub_list;
	SubWindow	*sub_plug;

public slots:
	void	serverList();
	void	pluginList();
	void	raiseServer(QAction *);

private slots:
	void	windowDestroyed(const SubWindow *);
	void	destroyServerList();
	void	destroyPluginList();
	void	showMessage(QMdiSubWindow *);
	void	changeConnection(SqlAccount *);
	void	connectServers();
	void	destroyServer(const QWidget *);
	void	addPlugin(QPluginLoader *);
	void	serverChanged(SqlAccount *);

signals:
	void	message(const QString&);
};

#endif  /* __WORKSPACE_H__ */

/* EOF */
