/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: gui.h,v 1.37 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __GUI_H__
#define __GUI_H__

#include <QApplication>
#include <QMainWindow>
#include <QMenu>
#include <QMenuBar>
#include <QKeySequence>
#include <QMessageBox>
#include <QDialog>
#include <QVBoxLayout>
#include <QDialogButtonBox>
#include <QFormLayout>
#include <QLineEdit>
#include <QSpinBox>
#include <QGroupBox>
#include <QCheckBox>
#include <QHBoxLayout>
#include <QLabel>
#include <QPushButton>
#include <QFileDialog>
#include <QKeyEvent>
#include <QAbstractTableModel>
#include <QTableView>
#include <QHeaderView>
#include <QHostAddress>		/* used in SqlConfig */
#include <QSettings>
#include <QMdiArea>
#include <QMdiSubWindow>
#include <QStatusBar>
#include <QTimer>
#include <QList>
#include <QPainter>
#include <QImage>
#include <QPalette>
#include <QTranslator>
#include <QLibraryInfo>
#include <QThread>
#include <QMutex>
#include <QWaitCondition>
#include <QTabWidget>
#include <QToolBar>
#include <QQueue>
#include <QScrollArea>
#include <QtPlugin>
#include <QPluginLoader>
#include <QFileInfo>
#include <QMetaType>
#include <QTextCodec>
#include <QSplitter>
#include <QRadioButton>
#include <QTreeView>
#include <QGridLayout>
#include <QComboBox>
#include <QTextBrowser>
#include <QRegExp>
#include <QRegExpValidator>
#include <QLCDNumber>

#include "qt_dep.h"

#define	DEFAULT_WINDOW_SIZE	QSize(800, 600)

#define	MARGINS(l, m)		do	{				\
	QFormLayout	*_local_form = qobject_cast<QFormLayout *>(l);	\
	(l)->setContentsMargins(m, m, m, m);				\
	(l)->setSpacing(2);						\
	if (_local_form != NULL)					\
		_local_form->setHorizontalSpacing((l)->spacing() * 2);	\
} while (0)
#define	MARGINS_ZERO(l)		MARGINS(l, 0)
#define	WINDOW_MODIFICATOR	"[*]"
#define	WIN_MOD_AFTER		" "WINDOW_MODIFICATOR
#define	WIN_MOD_BEFORE		WINDOW_MODIFICATOR" "

#define	RELOAD_INTERVAL		1000	/* 250 */
#define	RELOAD_TIMER(timer)	(timer)->start(RELOAD_INTERVAL)

#define	IF_DELETE(obj)		do {					\
	if ((obj) != NULL)						\
		delete (obj);						\
} while (0)

#define	SAFE_DELETE(obj)	do {					\
	IF_DELETE(obj);							\
	(obj) = NULL;							\
} while (0)

#define	DELETE_TRANSLATOR(tr)	do {					\
	QApplication::removeTranslator(tr);				\
	SAFE_DELETE(tr);						\
} while (0)

#define	DEFAULT_SECTION_HEIGHT(item)					\
	((item)->fontMetrics().lineSpacing() * 5 / 3)

#define	BASIC_VIEW_INIT(view, hdr)	do {				\
	(hdr)->setStretchLastSection(TRUE);				\
	(hdr)->setResizeMode(QHeaderView::ResizeToContents);		\
	(hdr)->setSortIndicatorShown(FALSE);				\
									\
	(view)->setSelectionMode(QAbstractItemView::SingleSelection);	\
	(view)->setSelectionBehavior(QAbstractItemView::SelectRows);	\
	(view)->setVerticalScrollMode(QAbstractItemView::ScrollPerPixel);\
	(view)->setHorizontalScrollMode(QAbstractItemView::ScrollPerPixel);\
} while (0)

#define	TABLE_VIEW_INIT(view)	do {					\
	QHeaderView	*hdr;						\
									\
	hdr = (view)->verticalHeader();					\
	hdr->setResizeMode(QHeaderView::Fixed);				\
	hdr->setDefaultSectionSize(DEFAULT_SECTION_HEIGHT(hdr));	\
	hdr->hide();							\
	(view)->setShowGrid(TRUE);					\
	(view)->setGridStyle(Qt::DotLine);				\
	BASIC_VIEW_INIT(view, (view)->horizontalHeader());		\
} while (0)

#define	TREE_VIEW_INIT(view)	do {					\
	BASIC_VIEW_INIT(view, (view)->header());			\
	(view)->setWordWrap(TRUE);					\
} while (0)

/* no user, no password, no ssl */
#define	BRUSH_NO_SECURITY	QBrush(Qt::red)
#define	BRUSH_LOW_SECURITY	QBrush(QColor(0xFF, 0xA6, 0x8D))
#define	BRUSH_MID_SECURITY	QBrush(QColor(0xFC, 0xFF, 0x57))
#define	BRUSH_NORMAL_SECURITY	QBrush(QColor(0xA7, 0xFF, 0xF2))
#define	BRUSH_SHUTDOWN		QBrush(QColor(0xEF, 0x93, 0x93))
#define	BRUSH_CONNECTED		QBrush(Qt::green)

typedef	quint32	flags_t;

#include "osdep.h"

typedef	struct {
	QString	title;
	QString	text;
} Confirm;

class Core
{
public:
	enum Text {
		Yes,
		No,
		Add,
		Edit,
		Delete,
		Close,
		Undefined,
		Unlimited,
		NoDescription,
		NewObjectPrivileges,
		Procedure,
		Function,
		Unknown,
		None,
		Unused,
		UnknownVariable
	};

	static void	noData(QWidget *parent = NULL);
	static void	notImplemented(QWidget *parent = NULL);

	static bool	doubleConfirm(const Confirm&, const Confirm&,
				QWidget *parent = NULL);
	static QString	hasPassword(const QString&);
	static QString	hasValue(bool);
	static QString	text(Text);
	static QString	informationSchema(const QString&);
	static QString	systemTable(const QString&);
	static QString	bool2string(bool);
	static bool	string2bool(const QString&);
	static QWidget	*addLegendItem(const QString&, const QBrush&,
				QWidget *parent = NULL);
	static QWidget	*accountLegend(QWidget *parent = NULL);

	static QTranslator	*installTranslator(const QString&,
					QObject *parent = NULL);
};

//-----------------------------------------------------------------------------
/* Related functions */
ostream& operator<<(ostream&, const QString&);

#endif  /* __GUI_H__ */

/* EOF */
