/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_config.h,v 1.7 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Describes data to connect to an SQL server
 */

#ifndef __SQL_CONFIG_H__
#define __SQL_CONFIG_H__

#include "gui.h"
#include "sql_user.h"


#define	SQL_RECONNECT	0x01	/* auto reconnect if the connection lost */
#define	SQL_COMPRESS	0x02	/* use compressed protocol */
#define	SQL_SSL		0x04	/* use SSL for this connection */
#define	SQL_AUTO_LOGIN	0x08	/* autoconnect at startup time */
#define	SQL_ASK_ACCOUNT	0x10	/* ask account at start time */

#define	SQL_FLAGS_MASK	(SQL_RECONNECT | SQL_COMPRESS | SQL_SSL |	\
	SQL_AUTO_LOGIN | SQL_ASK_ACCOUNT)


class SqlConfig:public SqlUser
{
public:
	SqlConfig();
	SqlConfig(const SqlConfig&);
	~SqlConfig();

	void	setPort(int);
	void	setReadTimeout(int);
	void	setWriteTimeout(int);
	void	setConnectTimeout(int);
	void	setConfig(const SqlConfig&);
	void	setFlag(flags_t, bool);
	void	setSSL(const QString&, const QString&, const QString&,
			const QString&, const QString&);
	void	save(QSettings&);

	int	port()const;
	int	readTimeout()const;
	int	writeTimeout()const;
	int	connectTimeout()const;
	flags_t	flags()const;
	bool	isSet(flags_t)const;
	QString	key()const;
	QString	cert()const;
	QString	ca()const;
	QString	caPath()const;
	QString	cipher()const;
	QString	account()const;
	bool	load(QSettings&);

	SqlConfig&	operator=(const SqlConfig&);
	bool		operator!=(const SqlConfig&)const;

private:
	int	sql_port;
	int	sql_read_timeout;
	int	sql_write_timeout;
	int	sql_conn_timeout;
	flags_t	sql_flags;
	QString	ssl_key;
	QString	ssl_cert;
	QString	ssl_ca;
	QString	ssl_capath;
	QString	ssl_cipher;

	QByteArray	encrypted()const;
	QString		decrypted(const QByteArray&)const;
};

#endif  /* __SQL_CONFIG_H__ */

/* EOF */
