/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_connection.h,v 1.14 2013/09/19 12:40:38 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_CONNECTION_H__
#define __SQL_CONNECTION_H__

#include "gui.h"
#include "sql_privileges_flags.h"

#define	SQL_VERSION(major, minor, subv)					\
	((major) * 10000 + (minor) * 100 + (subv))


class SqlConfig;
class SqlError;
class SqlPrivilegesFlags;
class SqlConnection_Private;

class GrantInfo
{
public:
	enum Type {
		G_GLOBAL,	/* user: Host + User */
		G_DATABASE,	/* db: Host + User + Db */
		G_TABLE,	/* tables_priv: Host + Db + User + Table_name */
		G_COLUMN,	/* columns_priv: Host + Db + User + Table_name + Column_name */
		G_PROC,		/* procs_priv: Host + User + Db + Routine_name + Routine_type */
		G_PROXY		/* proxies_priv: Host + User + Proxied_host + Proxied_user */
	};

	Type	type;
	QString	host;
	QString	user;
	QString	db;
	QString	table;
	QString	column;
	QString	proc;
	QString	func;
	QString	proxy_host;
	QString	proxy_user;

	GrantInfo();

	static void	commit(QStringList&, const GrantInfo&,
				const SqlPrivilegesFlags&,
				const SqlPrivilegesFlags&);

	static QString	systemTable(Type);
};

//-----------------------------------------------------------------------------

class SqlConnection
{
public:
	SqlConnection();
	~SqlConnection();

	void	connect(const char *, QObject *, const char *);
	void	connect(const SqlConfig *);
	void	connect();
	void	close();

	quint64		checksum(const QString&);
	quint64		checksum(GrantInfo::Type);
	SqlError	refresh(unsigned int);
	SqlError	shutdown();
	unsigned long	threadId();
	SqlError	kill(unsigned long);
	SqlError	exec(const QString&);
	SqlError	exec(const QStringList&);
	QString		account()const;
	unsigned long	serverVersion();
	int		size();
	SqlPrivilegesMap	privileges(const GrantInfo&);

	operator SqlConnection_Private*();

	static bool	tryConnection(const SqlConfig&, SqlError&);
	static int	defaultPort();
	static QString	defaultHost();
	static QString	defaultUser();

private:
	SqlConnection_Private	*priv;
	QThread			*thr;
};

#endif  /* __SQL_CONNECTION_H__ */

/* EOF */
