/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_error.h,v 1.5 2013/10/30 07:20:44 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_ERROR_H__
#define __SQL_ERROR_H__

#include "gui.h"

class SqlError
{
public:
	SqlError();
	SqlError(int, const QString&);
	SqlError(const SqlError&);
	~SqlError();

	void	clear();
	void	setError(int, const QString&);
	void	setError(const SqlError&);
	void	show(QWidget *parent = NULL)const;

	int	errcode()const;
	QString	error()const;

	SqlError&	operator=(const SqlError&);
	bool		operator==(int)const;
	bool		operator!=(int)const;

	operator QString()const;

	static void	registerMeta();

private:
	int	sql_errno;
	QString	sql_error;
};

//-----------------------------------------------------------------------------

/* Related functions */
ostream&	operator<<(ostream&, const SqlError&);

#endif  /* __SQL_ERROR_H__ */

/* EOF */
