/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_privileges_flags.h,v 1.8 2013/11/05 08:29:30 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_PRIVILEGES_FLAGS_H__
#define __SQL_PRIVILEGES_FLAGS_H__

#include "gui.h"

class SqlPrivilegesFlags;
typedef	QMap<QString, SqlPrivilegesFlags>	SqlPrivilegesMap;

typedef	quint64					sql_privileges_t;

#define	PRIV_USAGE		0x0000000000000000ULL
#define	PRIV_SELECT		0x0000000000000001ULL
#define	PRIV_INSERT		0x0000000000000002ULL
#define	PRIV_UPDATE		0x0000000000000004ULL
#define	PRIV_DELETE		0x0000000000000008ULL
#define	PRIV_CREATE		0x0000000000000010ULL
#define	PRIV_DROP		0x0000000000000020ULL
#define	PRIV_RELOAD		0x0000000000000040ULL
#define	PRIV_SHUTDOWN		0x0000000000000080ULL
#define	PRIV_PROCESS		0x0000000000000100ULL
#define	PRIV_FILE		0x0000000000000200ULL
#define	PRIV_GRANT		0x0000000000000400ULL
#define	PRIV_REFERENCES		0x0000000000000800ULL
#define	PRIV_INDEX		0x0000000000001000ULL
#define	PRIV_ALTER		0x0000000000002000ULL
#define	PRIV_SHOW_DB		0x0000000000004000ULL
#define	PRIV_SUPER		0x0000000000008000ULL
#define	PRIV_CREATE_TMP_TABLE	0x0000000000010000ULL
#define	PRIV_LOCK_TABLES	0x0000000000020000ULL
#define	PRIV_EXECUTE		0x0000000000040000ULL
#define	PRIV_REPL_SLAVE		0x0000000000080000ULL
#define	PRIV_REPL_CLIENT	0x0000000000100000ULL
#define	PRIV_CREATE_VIEW	0x0000000000200000ULL
#define	PRIV_SHOW_VIEW		0x0000000000400000ULL
#define	PRIV_CREATE_ROUTINE	0x0000000000800000ULL
#define	PRIV_ALTER_ROUTINE	0x0000000001000000ULL
#define	PRIV_CREATE_USER	0x0000000002000000ULL
#define	PRIV_EVENT		0x0000000004000000ULL
#define	PRIV_TRIGGER		0x0000000008000000ULL
#define	PRIV_CREATE_TABLESPACE	0x0000000010000000ULL

#define	PRIV_ACCESS_DENIED	0x1000000000000000ULL	/* error */
#define	PRIV_NOT_READY		0x2000000000000000ULL	/* not ready */

#define	PRIV_INITIALIZER	PRIV_USAGE
#define	PRIV_MASK		(PRIV_SELECT | PRIV_INSERT |		\
	PRIV_UPDATE | PRIV_DELETE | PRIV_CREATE | PRIV_DROP |		\
	PRIV_RELOAD | PRIV_SHUTDOWN | PRIV_PROCESS | PRIV_FILE |	\
	PRIV_GRANT | PRIV_REFERENCES | PRIV_INDEX | PRIV_ALTER |	\
	PRIV_SHOW_DB | PRIV_SUPER | PRIV_CREATE_TMP_TABLE| 		\
	PRIV_LOCK_TABLES | PRIV_EXECUTE | PRIV_REPL_SLAVE |		\
	PRIV_REPL_CLIENT | PRIV_CREATE_VIEW | PRIV_SHOW_VIEW |		\
	PRIV_CREATE_ROUTINE | PRIV_ALTER_ROUTINE | PRIV_CREATE_USER |	\
	PRIV_EVENT | PRIV_TRIGGER | PRIV_CREATE_TABLESPACE |		\
	PRIV_ACCESS_DENIED | PRIV_NOT_READY)

//-----------------------------------------------------------------------------

#define	FLD_SELECT_PRIV			"Select_priv"
#define	FLD_INSERT_PRIV			"Insert_priv"
#define	FLD_UPDATE_PRIV			"Update_priv"
#define	FLD_DELETE_PRIV			"Delete_priv"
#define	FLD_CREATE_PRIV			"Create_priv"
#define	FLD_DROP_PRIV			"Drop_priv"
#define	FLD_RELOAD_PRIV			"Reload_priv"
#define	FLD_SHUTDOWN_PRIV		"Shutdown_priv"
#define	FLD_PROCESS_PRIV		"Process_priv"
#define	FLD_FILE_PRIV			"File_priv"
#define	FLD_GRANT_PRIV			"Grant_priv"
#define	FLD_REFERENCES_PRIV		"References_priv"
#define	FLD_INDEX_PRIV			"Index_priv"
#define	FLD_ALTER_PRIV			"Alter_priv"
#define	FLD_SHOW_DB_PRIV		"Show_db_priv"
#define	FLD_SUPER_PRIV			"Super_priv"
#define	FLD_CREATE_TMP_TABLE_PRIV	"Create_tmp_table_priv"
#define	FLD_LOCK_TABLES_PRIV		"Lock_tables_priv"
#define	FLD_EXECUTE_PRIV		"Execute_priv"
#define	FLD_REPL_SLAVE_PRIV		"Repl_slave_priv"
#define	FLD_REPL_CLIENT_PRIV		"Repl_client_priv"
#define	FLD_CREATE_VIEW_PRIV		"Create_view_priv"
#define	FLD_SHOW_VIEW_PRIV		"Show_view_priv"
#define	FLD_CREATE_ROUTINE_PRIV		"Create_routine_priv"
#define	FLD_ALTER_ROUTINE_PRIV		"Alter_routine_priv"
#define	FLD_CREATE_USER_PRIV		"Create_user_priv"
#define	FLD_EVENT_PRIV			"Event_priv"
#define	FLD_TRIGGER_PRIV		"Trigger_priv"
#define	FLD_CREATE_TABLESPACE_PRIV	"Create_tablespace_priv"

//-----------------------------------------------------------------------------

class SqlPrivilegesFlags
{
public:
	enum ProcType {
		P_NONE,		/* no proc type, default */
		P_PROC,		/* procedure */
		P_FUNC		/* function */
	};

	SqlPrivilegesFlags();
	SqlPrivilegesFlags(const sql_privileges_t);
	SqlPrivilegesFlags(const SqlPrivilegesFlags&);
	~SqlPrivilegesFlags();

	void	setFlag(sql_privileges_t, bool on = TRUE);
	void	setProcType(ProcType);

	sql_privileges_t	flags()const;
	bool			isSet(sql_privileges_t)const;
	QString			toString()const;
	ProcType		procType()const;

	operator sql_privileges_t()const;

	SqlPrivilegesFlags&	operator=(const SqlPrivilegesFlags&);
	SqlPrivilegesFlags&	operator=(const sql_privileges_t);
	SqlPrivilegesFlags&	operator+=(const SqlPrivilegesFlags&);
	SqlPrivilegesFlags&	operator+=(const sql_privileges_t);
	SqlPrivilegesFlags&	operator-=(const SqlPrivilegesFlags&);
	SqlPrivilegesFlags&	operator-=(const sql_privileges_t);
	bool			operator==(const SqlPrivilegesFlags&)const;
	bool			operator==(const sql_privileges_t)const;
	bool			operator!=(const SqlPrivilegesFlags&)const;
	bool			operator!=(const sql_privileges_t)const;

private:
	sql_privileges_t	p_flags;
	ProcType		p_type;

protected:
	void	setInternalFlags(const sql_privileges_t);
};

#endif  /* __SQL_PRIVILEGES_FLAGS_H__ */

/* EOF */
