/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_query.h,v 1.5 2013/08/28 12:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_QUERY_H__
#define __SQL_QUERY_H__

#include "gui.h"


class SqlConnection;
class SqlQuery_Private;

class SqlQuery
{
public:
	enum Scope {
		S_SESSION,
		S_GLOBAL
	};
	enum Table {
		T_STATUS,
		T_VARIABLES
	};

	SqlQuery(SqlConnection *);
	~SqlQuery();

	void	connect(QObject *, const char *);
	void	free();
	void	prepare(const QString&);

	void	exec();
	void	bind(unsigned long, QString&);

	bool		next();
	QVariant	value(unsigned long)const;
	QVariant	value(const QString&)const;
	SqlConnection	*connection()const;

	QVariant	operator[](unsigned long)const;
	QVariant	operator[](const QString&)const;

	static QString	query(const QString&, Table, Scope scope = S_GLOBAL);

private:
	SqlQuery_Private	*priv;
};

#endif  /* __SQL_QUERY_H__ */

/* EOF */
