/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_service.h,v 1.7 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_SERVICE_H__
#define __SQL_SERVICE_H__

#include "server_info.h"

#define	service_cast(obj)	dynamic_cast<SqlService *>(obj)


class SqlService
{
public:
	SqlService(ServerInfo *, const QString&);
	virtual ~SqlService();

	QString	service()const;

	virtual void	timeout() = 0;
	virtual void	privilegesChanged();

	virtual QString	tabName() = 0;

private:
	ServerInfo	*p_info;
	QString		p_service;	/* name of this service */

protected:
	ServerInfo	*info()const;
	SqlConnection	*connection()const;

	virtual void	destroyIt();
};

//-----------------------------------------------------------------------------

class ServicePlugin
{
public:
	ServicePlugin(const QString&, const QString&);
	virtual ~ServicePlugin();

	QString	description()const;
	QString	name()const;

	virtual QWidget	*create(ServerInfo *, QWidget *parent = NULL) = 0;

private:
	QString		p_name;	/* name of the plugin */
	QString		p_desc;	/* description of the plugin */
	QTranslator	*qt;	/* message translator */

protected:
	void	initTranslator(const QString&);
};

Q_DECLARE_INTERFACE(ServicePlugin, "SilverSoft.Net/ServicePlugin/1.0");

#endif  /* __SQL_SERVICE_H__ */

/* EOF */
