/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: sql_user.h,v 1.3 2013/09/10 11:32:08 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __SQL_USER_H__
#define __SQL_USER_H__

#include "gui.h"

class SqlUser
{
public:
	SqlUser();
	SqlUser(const SqlUser&);
	~SqlUser();

	void	setUser(const SqlUser&);
	void	setUser(const QString&);
	void	setHost(const QString&);
	void	setPassword(const QString&);

	QString	user()const;
	QString	host()const;
	QString	password()const;
	QString	account(bool quoted = FALSE)const;
	bool	isEmpty()const;

	SqlUser&	operator=(const SqlUser&);
	bool		operator!=(const SqlUser&);

	static QString	account(const QString&, const QString&);
	static SqlUser	split(const QString&);

private:
	QString	p_user;
	QString	p_host;
	QString	p_pass;

protected:
	QString	accountFormat(bool)const;
};

//-----------------------------------------------------------------------------

ostream&	operator<<(ostream&, const SqlUser&);

#endif  /* __SQL_USER_H__ */

/* EOF */
