/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: charset.cpp,v 1.2 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "charset.h"


Charset::Charset()
	:BasicData()
{
	QString	null(QString::null);

	setCharset(null);
	setCollate(null);
	setDescription(null);
	setMaxLen(0);
}

Charset::Charset(const Charset &cset)
	:BasicData()
{

	setCharset(cset);
}

Charset::~Charset()
{
}


void
Charset::setCharset(const Charset &cset)
{

	setCharset(cset.charset());
	setCollate(cset.collate());
	setDescription(cset.description());
	setMaxLen(cset.maxLen());
	setInternalFlags(cset.flags());
}


void
Charset::setCharset(const QString &c)
{

	p_char = c;
}


void
Charset::setCollate(const QString &c)
{

	p_coll = c;
}


void
Charset::setDescription(const QString &d)
{

	p_desc = d;
}


void
Charset::setMaxLen(qint64 l)
{

	p_mlen = l;
}


QString
Charset::charset()const
{

	return (p_char);
}


QString
Charset::collate()const
{

	return (p_coll);
}


QString
Charset::description()const
{

	return (p_desc);
}


qint64
Charset::maxLen()const
{

	return (p_mlen);
}

/* EOF */
