/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: charset.h,v 1.1 2013/08/08 12:51:21 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __CHARSET_H__
#define __CHARSET_H__

#include "gui.h"
#include "basic_data.h"

class Charset;
typedef	QVector<Charset *>		CharsetVector;
typedef	QMap<QString, Charset *>	CharsetMap;

class Charset:public BasicData
{
public:
	Charset();
	Charset(const Charset&);
	~Charset();

	void	setCharset(const Charset&);
	void	setCharset(const QString&);
	void	setCollate(const QString&);
	void	setDescription(const QString&);
	void	setMaxLen(qint64);

	QString	charset()const;
	QString	collate()const;
	QString	description()const;
	qint64	maxLen()const;

private:
	QString	p_char;	/* character_sets.character_set_name */
	QString	p_coll;	/* character_sets.default_collate_name */
	QString	p_desc;	/* character_sets.description */
	qint64	p_mlen;	/* character_sets.maxlen */
};

#endif  /* __CHARSET_H__ */

/* EOF */
