/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: charset_model.h,v 1.2 2013/08/09 12:06:42 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __CHARSET_MODEL_H__
#define __CHARSET_MODEL_H__

#include "gui.h"
#include "charset.h"


class SqlConnection;
class SqlQuery;


class CharsetModel:public QAbstractTableModel
{
	Q_OBJECT
public:
	CharsetModel(SqlConnection *, QObject *parent = NULL);
	virtual ~CharsetModel();

	void	timeout();
	void	clearSelection();
	void	selectCharset(const QString&, QModelIndex&);

	bool	isEmpty()const;
	Charset	*charset(const QModelIndex&)const;
	Charset	*charset(int)const;

	virtual QVariant	data(const QModelIndex&, int)const;
	virtual QVariant	headerData(int, Qt::Orientation, int)const;
	virtual int		columnCount(const QModelIndex&)const;
	virtual int		rowCount(const QModelIndex&)const;

private:
	CharsetVector	vect;
	CharsetMap	map;
	SqlQuery	*query;

	void	markAll();
	void	deleteMarked(unsigned long&);
	void	copyData(Charset&, SqlQuery *);
	void	updateData(Charset *, const Charset&, unsigned long&);
	void	changed(int&, int, Charset *, unsigned long&);

	int		findPosition(const QString&);
	QVariant	displayData(const Charset *, int)const;
	QVariant	backgroundData(const Charset *)const;
	int		fieldPosition(const char *);

private slots:
	void	reloadData();

signals:
	void	modelChanged();
};

#endif  /* __CHARSET_MODEL_H__ */

/* EOF */
