/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: charsets.cpp,v 1.3 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "charsets.h"
#include "charset_model.h"
#include "plg_gui.h"


Charsets::Charsets(SqlConnection *conn, QWidget *parent)
	:QWidget(parent)
{

	model = new CharsetModel(conn, this);
	connect(model, SIGNAL(modelChanged()), this, SLOT(selectItem()));

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	view = new QTableView(this);
	view->setModel(model);
	TABLE_VIEW_INIT(view);
	connect(view, SIGNAL(pressed(const QModelIndex&)),
		this, SLOT(charsetChanged(const QModelIndex&)));
	layout->addWidget(view, 1);
}

Charsets::~Charsets()
{

	delete view;
	delete layout;
	delete model;
}


void
Charsets::timeout()
{

	model->timeout();
}


void
Charsets::selectItem()
{
	QItemSelectionModel	*sel = view->selectionModel();

	if ((sel != NULL) && !sel->hasSelection())
		view->setCurrentIndex(model->index(0, 0));

	charsetChanged(view->currentIndex());
}


void
Charsets::charsetChanged(const QModelIndex &ndx)
{
	Charset	*cset = model->charset(ndx);

	if (cset == NULL)
		Core::noData(this);
	else {
		model->clearSelection();
		emit selectCollation(cset->charset());
	}
}


void
Charsets::selectCharset(const QString &coll)
{
	QModelIndex	ndx;

	SHOW_SELECTED(ndx, selectCharset, coll);
}

/* EOF */
