/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: collation.cpp,v 1.2 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "collation.h"


Collation::Collation()
	:BasicData()
{
	QString	null(QString::null);

	setCollation(null);
	setCharset(null);
	setId(-1);
	setDefault(null);
	setCompiled(null);
	setSortLen(-1);
}

Collation::Collation(const Collation &coll)
	:BasicData()
{

	setCollation(coll);
}

Collation::~Collation()
{
}


void
Collation::setCollation(const Collation &coll)
{

	setCollation(coll.collation());
	setCharset(coll.charset());
	setId(coll.id());
	setDefault(coll.isDefault());
	setCompiled(coll.isCompiled());
	setSortLen(coll.sortLen());
	setInternalFlags(coll.flags());
}


void
Collation::setCollation(const QString &c)
{

	p_coll = c;
}


void
Collation::setCharset(const QString &c)
{

	p_char = c;
}


void
Collation::setId(qint64 id)
{

	p_id = id;
}


void
Collation::setDefault(const QString &def)
{

	p_def = def;
}


void
Collation::setCompiled(const QString &c)
{

	p_comp = c;
}


void
Collation::setSortLen(qint64 sl)
{

	p_slen = sl;
}


QString
Collation::collation()const
{

	return (p_coll);
}


QString
Collation::charset()const
{

	return (p_char);
}


qint64
Collation::id()const
{

	return (p_id);
}


QString
Collation::isDefault()const
{

	return (p_def);
}


QString
Collation::isCompiled()const
{

	return (p_comp);
}


qint64
Collation::sortLen()const
{

	return (p_slen);
}

/* EOF */
