/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: collation.h,v 1.1 2013/08/08 12:51:21 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __COLLATION_H__
#define __COLLATION_H__

#include "gui.h"
#include "basic_data.h"

class Collation;
typedef	QVector<Collation *>		CollationVector;
typedef	QMap<QString, Collation *>	CollationMap;

class Collation:public BasicData
{
public:
	Collation();
	Collation(const Collation&);
	~Collation();

	void	setCollation(const Collation&);
	void	setCollation(const QString&);
	void	setCharset(const QString&);
	void	setId(qint64);
	void	setDefault(const QString&);
	void	setCompiled(const QString&);
	void	setSortLen(qint64);

	QString	collation()const;
	QString	charset()const;
	qint64	id()const;
	QString	isDefault()const;
	QString	isCompiled()const;
	qint64	sortLen()const;

private:
	QString	p_coll;	/* collations.collation_name */
	QString	p_char;	/* collations.character_set_name */
	qint64	p_id;	/* collations.id */
	QString	p_def;	/* collations.is_default */
	QString	p_comp;	/* collations.is_compiled */
	qint64	p_slen;	/* collations.sortlen */
};

#endif  /* __COLLATION_H__ */

/* EOF */
