/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: collations.cpp,v 1.2 2013/08/09 12:06:43 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "collations.h"
#include "collation_model.h"
#include "plg_gui.h"


Collations::Collations(SqlConnection *conn, QWidget *parent)
	:QWidget(parent)
{

	model = new CollationModel(conn, this);

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	view = new QTableView(this);
	view->setModel(model);
	TABLE_VIEW_INIT(view);
	connect(view, SIGNAL(pressed(const QModelIndex&)),
		this, SLOT(collationChanged(const QModelIndex&)));
	layout->addWidget(view, 1);
}

Collations::~Collations()
{

	delete view;
	delete layout;
	delete model;
}


void
Collations::timeout()
{

	model->timeout();
}


void
Collations::selectCollation(const QString &cset)
{
	QModelIndex	ndx;

	SHOW_SELECTED(ndx, selectCollation, cset);
}


void
Collations::collationChanged(const QModelIndex &ndx)
{
	Collation	*coll = model->collation(ndx);

	if (coll == NULL)
		Core::noData(this);
	else {
		model->clearSelection();
		emit selectCharset(coll->charset());
	}
}

/* EOF */
