/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: contributor.cpp,v 1.1 2013/08/08 12:51:21 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "plugin.h"


Plugin::Plugin()
	:BasicData()
{

	setPluginName(QString::null);
}

Plugin::Plugin(const Plugin &plg)
	:BasicData()
{

	setPlugin(plg);
}

Plugin::~Plugin()
{
}


void
Plugin::setPlugin(const Plugin &plg)
{

	setPluginName(plg.pluginName());
	setPluginVersion(plg.pluginVersion());
	setPluginStatus(plg.pluginStatus());
	setPluginType(plg.pluginType());
	setPluginTypeVersion(plg.pluginTypeVersion());
	setPluginLibrary(plg.pluginLibrary());
	setPluginLibraryVersion(plg.pluginLibraryVersion());
	setPluginAuthor(plg.pluginAuthor());
	setPluginDescription(plg.pluginDescription());
	setPluginLicense(plg.pluginLicense());
	setLoadOption(plg.loadOption());
	setPluginMaturity(plg.pluginMaturity());
	setPluginAuthVersion(plg.pluginAuthVersion());
}


void
Plugin::setPluginName(const QString &n)
{

	p_name = n;
}


void
Plugin::setPluginVersion(const QString &v)
{

	p_version = v;
}


void
Plugin::setPluginStatus(const QString &s)
{

	p_status = s;
}


void
Plugin::setPluginType(const QString &t)
{

	p_type = t;
}


void
Plugin::setPluginTypeVersion(const QString &v)
{

	p_type_version = v;
}


void
Plugin::setPluginLibrary(const QString &l)
{

	p_library = l;
}


void
Plugin::setPluginLibraryVersion(const QString &v)
{

	p_lib_version = v;
}


void
Plugin::setPluginAuthor(const QString &a)
{

	p_author = a;
}


void
Plugin::setPluginDescription(const QString &d)
{

	p_description = d;
}


void
Plugin::setPluginLicense(const QString &l)
{

	p_license = l;
}


void
Plugin::setLoadOption(const QString &o)
{

	p_load_option = o;
}


void
Plugin::setPluginMaturity(const QString &m)
{

	p_maturity = m;
}


void
Plugin::setPluginAuthVersion(const QString &v)
{

	p_auth_version = v;
}


QString
Plugin::pluginName()const
{

	return (p_name);
}


QString
Plugin::pluginVersion()const
{

	return (p_version);
}


QString
Plugin::pluginStatus()const
{

	return (p_status);
}


QString
Plugin::pluginType()const
{

	return (p_type);
}


QString
Plugin::pluginTypeVersion()const
{

	return (p_type_version);
}


QString
Plugin::pluginLibrary()const
{

	return (p_library);
}


QString
Plugin::pluginLibraryVersion()const
{

	return (p_lib_version);
}


QString
Plugin::pluginAuthor()const
{

	return (p_author);
}


QString
Plugin::pluginDescription()const
{

	return (p_description);
}


QString
Plugin::pluginLicense()const
{

	return (p_license);
}


QString
Plugin::loadOption()const
{

	return (p_load_option);
}


QString
Plugin::pluginMaturity()const
{

	return (p_maturity);
}


QString
Plugin::pluginAuthVersion()const
{

	return (p_auth_version);
}

/* EOF */
