/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: contributor.h,v 1.1 2013/08/08 12:51:21 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __CONTRIBUTOR_H__
#define __CONTRIBUTOR_H__

#include "gui.h"
#include "basic_data.h"

class Plugin;
typedef	QVector<Plugin *>	PluginVector;
typedef	QMap<QString, Plugin *>	PluginMap;

class Plugin:public BasicData
{
public:
	Plugin();
	Plugin(const Plugin&);
	~Plugin();

	void	setPlugin(const Plugin&);
	void	setPluginName(const QString&);
	void	setPluginVersion(const QString&);
	void	setPluginStatus(const QString&);
	void	setPluginType(const QString&);
	void	setPluginTypeVersion(const QString&);
	void	setPluginLibrary(const QString&);
	void	setPluginLibraryVersion(const QString&);
	void	setPluginAuthor(const QString&);
	void	setPluginDescription(const QString&);
	void	setPluginLicense(const QString&);
	void	setLoadOption(const QString&);
	void	setPluginMaturity(const QString&);
	void	setPluginAuthVersion(const QString&);

	QString	pluginName()const;
	QString	pluginVersion()const;
	QString	pluginStatus()const;
	QString	pluginType()const;
	QString	pluginTypeVersion()const;
	QString	pluginLibrary()const;
	QString	pluginLibraryVersion()const;
	QString	pluginAuthor()const;
	QString	pluginDescription()const;
	QString	pluginLicense()const;
	QString	loadOption()const;
	QString	pluginMaturity()const;
	QString	pluginAuthVersion()const;

private:
	QString	p_name;		/* plugins.plugin_name */
	QString	p_version;	/* plugins.plugin_version */
	QString	p_status;	/* plugins.plugin_status */
	QString	p_type;		/* plugins.plugin_type */
	QString	p_type_version;	/* plugins.plugin_type_version */
	QString	p_library;	/* plugins.plugin_library */
	QString	p_lib_version;	/* plugins.plugin_library_version */
	QString	p_author;	/* plugins.plugin_author */
	QString	p_description;	/* plugins.plugin_description */
	QString	p_license;	/* plugins.plugin_license */
	QString	p_load_option;	/* plugins.load_option */
	QString	p_maturity;	/* plugins.plugin_maturity */
	QString	p_auth_version;	/* plugins.plugin_auth_version */
};

#endif  /* __CONTRIBUTOR_H__ */

/* EOF */
