/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: contributor_model.h,v 1.1 2013/08/08 12:51:22 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __MYSQL_PLUGIN_MODEL_H__
#define __MYSQL_PLUGIN_MODEL_H__

#include "gui.h"
#include "plugin.h"


class SqlConnection;
class SqlQuery;


class MySQLPluginModel:public QAbstractTableModel
{
	Q_OBJECT
public:
	MySQLPluginModel(SqlConnection *, QObject *parent = NULL);
	virtual ~MySQLPluginModel();

	void	timeout();
	void	loadPlugin(const QString&, const QString&, QWidget *);
	void	unloadPlugin(const QString&, QWidget *);

	bool	isEmpty()const;
	Plugin	*plugin(const QModelIndex&)const;
	Plugin	*plugin(int)const;

	virtual QVariant	data(const QModelIndex&, int)const;
	virtual QVariant	headerData(int, Qt::Orientation, int)const;
	virtual int		columnCount(const QModelIndex&)const;
	virtual int		rowCount(const QModelIndex&)const;

private:
	PluginVector	vect;
	PluginMap	map;
	SqlQuery	*query;

	void	markAll();
	void	deleteMarked(unsigned long&);
	void	copyData(Plugin&, SqlQuery *);
	void	updateData(Plugin *, const Plugin&, unsigned long&);
	void	changed(int&, int, Plugin *, unsigned long&);

	int		findPosition(const QString&);
	QVariant	displayData(const Plugin *, int)const;
	//QVariant	backgroundData(const Plugin *)const;
	int		fieldPosition(const char *);

private slots:
	void	reloadData();

signals:
	void	modelChanged();
};

#endif  /* __MYSQL_PLUGIN_MODEL_H__ */

/* EOF */
