/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: contributors.cpp,v 1.2 2013/10/09 14:18:13 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "contributors.h"
#include "contributor_model.h"


Contributors::Contributors(SqlConnection *conn, QWidget *parent)
	:QWidget(parent), SqlService(conn, "contributors")
{

	model = new ContributorModel(conn, this);
	connect(model, SIGNAL(modelChanged()), this, SLOT(selectItem()));

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	view = new QTableView(this);
	view->setModel(model);
	TABLE_VIEW_INIT(view);
	layout->addWidget(view, 1);

	selectItem();
}

Contributors::~Contributors()
{

	delete view;
	delete layout;
	delete model;
}


void
Contributors::timeout()
{

	model->timeout();
}


QString
Contributors::tabName()
{

	return (tr("Contributors"));
}


void
Contributors::destroyIt()
{

	delete this;
}


void
Contributors::deleteNow()
{

	destroyIt();
}


void
Contributors::selectItem()
{
	QItemSelectionModel	*sel = view->selectionModel();
	bool			ena = !model->isEmpty();

	if ((sel != NULL) && !sel->hasSelection())
		view->setCurrentIndex(model->index(0, 0));
}

/* EOF */
