/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: engine.cpp,v 1.2 2013/08/20 10:12:39 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "engine.h"


Engine::Engine()
	:BasicData()
{

	setEngine(QString::null);
	setSupport(QString::null);
	setComment(QString::null);
	setTransactions(QString::null);
	setXa(QString::null);
	setSavepoints(QString::null);
}

Engine::Engine(const Engine &engine)
	:BasicData()
{

	setEngine(engine);
}

Engine::~Engine()
{
}


void
Engine::setEngine(const Engine &engine)
{

	setEngine(engine.engine());
	setSupport(engine.support());
	setComment(engine.comment());
	setTransactions(engine.transactions());
	setXa(engine.xa());
	setSavepoints(engine.savepoints());
	setInternalFlags(engine.flags());
}


void
Engine::setEngine(const QString &e)
{

	p_engine = e;
}


void
Engine::setSupport(const QString &s)
{

	p_support = s;
}


void
Engine::setComment(const QString &c)
{

	p_comment = c;
}


void
Engine::setTransactions(const QString &t)
{

	p_transactions = t;
}


void
Engine::setXa(const QString &xa)
{

	p_xa = xa;
}


void
Engine::setSavepoints(const QString &sp)
{

	p_savepoints = sp;
}


QString
Engine::engine()const
{

	return (p_engine);
}


QString
Engine::support()const
{

	return (p_support);
}


QString
Engine::comment()const
{

	return (p_comment);
}


QString
Engine::transactions()const
{

	return (p_transactions);
}


QString
Engine::xa()const
{

	return (p_xa);
}


QString
Engine::savepoints()const
{

	return (p_savepoints);
}

/* EOF */
