/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: engine.h,v 1.2 2013/08/07 11:59:52 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __ENGINE_H__
#define __ENGINE_H__

#include "gui.h"
#include "basic_data.h"

class Engine;
typedef	QVector<Engine *>	EngineVector;
typedef	QMap<QString, Engine *>	EngineMap;

class Engine:public BasicData
{
public:
	Engine();
	Engine(const Engine&);
	~Engine();

	void	setEngine(const Engine&);
	void	setEngine(const QString&);
	void	setSupport(const QString&);
	void	setComment(const QString&);
	void	setTransactions(const QString&);
	void	setXa(const QString&);
	void	setSavepoints(const QString&);

	QString	engine()const;
	QString	support()const;
	QString	comment()const;
	QString	transactions()const;
	QString	xa()const;
	QString	savepoints()const;

private:
	QString	p_engine;	/* engines.engine */
	QString	p_support;	/* engines.support */
	QString	p_comment;	/* engines.comment */
	QString	p_transactions;	/* engines.transactions */
	QString	p_xa;		/* engines.xa */
	QString	p_savepoints;	/* engines.savepoints */
};

#endif  /* __ENGINE_H__ */

/* EOF */
