/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: engine_model.h,v 1.3 2013/08/08 12:51:22 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __ENGINE_MODEL_H__
#define __ENGINE_MODEL_H__

#include "gui.h"
#include "engine.h"

#define	BRUSH_DEFAULT		QBrush(Qt::green)
#define	BRUSH_NOT_SUPPORTED	QBrush(Qt::red)


class SqlConnection;
class SqlQuery;


class EngineModel:public QAbstractTableModel
{
	Q_OBJECT
public:
	EngineModel(SqlConnection *, QObject *parent = NULL);
	virtual ~EngineModel();

	void	timeout();
	void	setDefault(const QString&, QWidget *);

	bool	isEmpty()const;
	Engine	*engine(const QModelIndex&)const;
	Engine	*engine(int)const;

	virtual QVariant	data(const QModelIndex&, int)const;
	virtual QVariant	headerData(int, Qt::Orientation, int)const;
	virtual int		columnCount(const QModelIndex&)const;
	virtual int		rowCount(const QModelIndex&)const;

private:
	EngineVector	vect;
	EngineMap	map;
	SqlQuery	*query;

	void	markAll();
	void	deleteMarked(unsigned long&);
	void	copyData(Engine&, SqlQuery *);
	void	updateData(Engine *, const Engine&, unsigned long&);
	void	changed(int&, int, Engine *, unsigned long&);

	int		findPosition(const QString&);
	QVariant	displayData(const Engine *, int)const;
	QVariant	backgroundData(const Engine *)const;
	int		fieldPosition(const char *);

private slots:
	void	reloadData();

signals:
	void	modelChanged();
};

#endif  /* __ENGINE_MODEL_H__ */

/* EOF */
