/*-
 * Copyright (c) 2013 by SilverSoft.Net
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: engines.h,v 1.3 2013/09/13 12:53:22 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#ifndef __ENGINES_H__
#define __ENGINES_H__

#include "gui.h"
#include "sql_service.h"


class EngineModel;
class EngineLegend;

class Engines:public QWidget, public SqlService
{
	Q_OBJECT
public:
	Engines(ServerInfo *, QWidget *parent = NULL);
	virtual ~Engines();

	virtual void	timeout();

	virtual QString	tabName();

private:
	QVBoxLayout	*layout;
	QHBoxLayout	*ctl;
	QTableView	*view;
	EngineModel	*model;
	EngineLegend	*legend;
	QPushButton	*def;

protected:
	virtual void	destroyIt();

public slots:
	void	deleteNow();

private slots:
	void	selectItem();
	void	setDefault();
	void	setDefault(const QModelIndex&);
	void	testEngine(const QModelIndex&, const QModelIndex&);
};

//-----------------------------------------------------------------------------

class EngineLegend:public QGroupBox
{
	Q_OBJECT
public:
	EngineLegend(QWidget *parent = NULL);
	~EngineLegend();

private:
	QVBoxLayout	*layout;
	QWidget		*l_def;
	QWidget		*l_ns;
};

#endif  /* __ENGINES_H__ */

/* EOF */
