/*-
 * Copyright (c) 2013 by SilverSoft.Net
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * $Id: grants.cpp,v 1.5 2013/10/09 14:18:14 denis Exp $
 */

/*-
 * Author: Denis Kozadaev (denis@silversoft.net)
 *
 * Please add file description here
 */

#include "grants.h"
#include "users.h"
#include "user_privileges.h"


Grants::Grants(ServerInfo *info, QWidget *parent)
	:QWidget(parent), SqlService(info, "grants")
{

	layout = new QVBoxLayout(this);
	MARGINS_ZERO(layout);

	split = new QSplitter(Qt::Horizontal, this);
	layout->addWidget(split, 1);

	users = new Users(info, this);
	split->addWidget(users);

	privs = new UserPrivileges(info, this);
	split->addWidget(privs);

	connect(users, SIGNAL(selected(const SqlUser&)),
		privs, SLOT(loadPrivileges(const SqlUser&)));
	privilegesChanged();
}

Grants::~Grants()
{

	delete privs;
	delete users;
	delete split;
	delete layout;
}


void
Grants::timeout()
{

	users->timeout();
	privs->timeout();
}


void
Grants::privilegesChanged()
{

	users->privilegesChanged();
	privs->privilegesChanged();
}


QString
Grants::tabName()
{

	return (tr("Grants"));
}


void
Grants::destroyIt()
{

	delete this;
}


void
Grants::deleteNow()
{

	destroyIt();
}

/* EOF */
